/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import rs.baselib.io.ConverterUtils;
import rs.baselib.lang.LangUtils;
import rs.baselib.licensing.AbstractLicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.LicenseException;

public class SimpleLicense
extends AbstractLicense {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(ILicenseContext context) {
        this.initProperty("product", context);
        this.initProperty("expirationDate", context);
        this.initProperty("owner", context);
    }

    public int getProduct() {
        return LangUtils.getInt(this.getProperty("product"), 0);
    }

    public void setProduct(int i) {
        this.setProperty("product", i);
    }

    public Date getExpirationDate() {
        long l = this.getExpiration();
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    public long getExpiration() {
        return LangUtils.getLong(this.getProperty("expirationDate"), 0L);
    }

    public void setExpirationDate(Date d) {
        if (d != null) {
            this.setProperty("expirationDate", d.getTime());
        } else {
            this.removeProperty("expirationDate");
        }
    }

    public String getOwner() {
        return LangUtils.getString(this.getProperty("owner"));
    }

    public void setOwner(String s) {
        this.setProperty("owner", s);
    }

    @Override
    public void verify(ILicenseContext context) {
        Date d;
        this.verifyEquals("product", context, true);
        this.verifyEquals("owner", context, true);
        if (!context.hasKey("expirationDate")) {
            context.set("expirationDate", (Object)System.currentTimeMillis());
        }
        if ((d = this.getExpirationDate()) != null) {
            long l = LangUtils.getLong(context.get("expirationDate"), 0L);
            if (d.getTime() < l) {
                throw new LicenseException("License expired on " + d.toString());
            }
        }
    }

    public static byte[] serialize(SimpleLicense license) throws UnsupportedEncodingException {
        byte[] p = ConverterUtils.toBytes(license.getProduct());
        byte[] d = ConverterUtils.toBytes((int)(license.getExpiration() / 1000L));
        String lh = license.getOwner();
        if (lh == null) {
            lh = "";
        }
        byte[] s = ConverterUtils.toBytes(lh);
        byte[] rc = new byte[s.length + 6];
        System.arraycopy(p, 2, rc, 0, 2);
        System.arraycopy(d, 0, rc, 2, 4);
        if (s.length > 0) {
            System.arraycopy(s, 0, rc, 6, s.length);
        }
        return rc;
    }
}

