/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import java.io.File;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.util.CommonUtils;

public class KeyGen
implements Runnable {
    private String algorithm;
    private int length;
    private boolean overwrite;
    private String file;
    private KeyPair keyPair;

    public KeyGen(String algorithm, int length, String file, boolean overwrite) {
        if (algorithm == null) {
            algorithm = "RSA";
        }
        if (length == 0) {
            length = 2048;
        }
        this.algorithm = algorithm;
        this.length = length;
        this.file = file;
        this.overwrite = overwrite;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getLength() {
        return this.length;
    }

    public String getFile() {
        return this.file;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void run() {
        try {
            System.out.println("Creating " + this.getAlgorithm() + " key with " + this.getLength() + " bit:");
            this.keyPair = EncryptionUtils.generateKey(this.getAlgorithm(), this.getLength());
            PrivateKey privateKey = this.keyPair.getPrivate();
            PublicKey publicKey = this.keyPair.getPublic();
            File f = new File(this.getFile() + ".public");
            if (f.exists() && !this.isOverwrite()) {
                throw new RuntimeException("   " + f.getAbsolutePath() + " already exists");
            }
            EncryptionUtils.save(f, publicKey);
            System.out.println("    Public Key: " + f.getAbsolutePath());
            f = new File(this.getFile() + ".private");
            if (f.exists() && !this.isOverwrite()) {
                throw new RuntimeException("   " + f.getAbsolutePath() + " already exists");
            }
            EncryptionUtils.save(f, privateKey);
            System.out.println("   Private Key: " + f.getAbsolutePath());
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] args) {
        Options options = KeyGen.getOptions();
        String algorithm = null;
        String file = null;
        int length = 0;
        boolean overwrite = false;
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("a")) {
                algorithm = cmd.getOptionValue("a");
            }
            if (cmd.hasOption("l")) {
                length = Integer.parseInt(cmd.getOptionValue("l"));
            }
            if (CommonUtils.isEmpty(file = cmd.getOptionValue("n"), true)) {
                KeyGen.printHelp(options);
                System.exit(-1);
            }
            overwrite = cmd.hasOption("f");
        }
        catch (ParseException e) {
            KeyGen.printHelp(options);
            System.exit(-1);
        }
        try {
            KeyGen keygen = new KeyGen(algorithm, length, file, overwrite);
            keygen.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("KeyGen", options);
    }

    protected static Options getOptions() {
        Options rc = new Options();
        Option option = new Option("a", "algorithm", true, "The algorithm to create the key (default: RSA)");
        option.setOptionalArg(true);
        rc.addOption(option);
        option = new Option("n", "name", true, "name of key");
        option.setOptionalArg(false);
        rc.addOption(option);
        option = new Option("l", "length", true, "the length of the key (default: 2048)");
        option.setOptionalArg(true);
        rc.addOption(option);
        option = new Option("f", "force", false, "overwrite any existing file (default: false)");
        option.setOptionalArg(false);
        rc.addOption(option);
        return rc;
    }
}

