/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReflectionUtils {
    public static boolean isInstanceOf(Object o, String className) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o.getClass();
        return ReflectionUtils.isInstanceOf(clazz, className);
    }

    public static boolean isInstanceOf(Class<?> inspectedClass, String className) {
        if (inspectedClass.getName().equals(className)) {
            return true;
        }
        for (Class<?> i : inspectedClass.getInterfaces()) {
            boolean rc = ReflectionUtils.isInstanceOf(i, className);
            if (!rc) continue;
            return true;
        }
        Class<?> parent = inspectedClass.getSuperclass();
        if (parent != null) {
            return ReflectionUtils.isInstanceOf(parent, className);
        }
        return false;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        if (childClass == null) {
            return null;
        }
        Class<?> typeClass = ReflectionUtils.getClass(type);
        while (typeClass != null && !typeClass.equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                }
                if (!rawType.equals(baseClass)) {
                    type = rawType.getGenericSuperclass();
                }
            }
            typeClass = ReflectionUtils.getClass(type);
        }
        ArrayList typeArgumentsAsClasses = new ArrayList();
        if (type != null) {
            Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
            for (Type baseType : actualTypeArguments) {
                while (resolvedTypes.containsKey(baseType)) {
                    baseType = (Type)resolvedTypes.get(baseType);
                }
                typeArgumentsAsClasses.add(ReflectionUtils.getClass(baseType));
            }
        }
        return typeArgumentsAsClasses;
    }

    public static boolean isPublic(Member member) {
        return (member.getModifiers() & 1) != 0;
    }

    public static boolean isProtected(Member member) {
        return (member.getModifiers() & 4) != 0;
    }

    public static boolean isPrivate(Member member) {
        return (member.getModifiers() & 2) != 0;
    }

    public static boolean isStatic(Member member) {
        return (member.getModifiers() & 8) != 0;
    }

    public static boolean isFinal(Member member) {
        return (member.getModifiers() & 0x10) != 0;
    }

    public static boolean isVolatile(Member member) {
        return (member.getModifiers() & 0x40) != 0;
    }

    public static boolean isSynchronized(Member member) {
        return (member.getModifiers() & 0x20) != 0;
    }

    public static boolean isAbstract(Member member) {
        return (member.getModifiers() & 0x400) != 0;
    }

    public static boolean isNative(Member member) {
        return (member.getModifiers() & 0x100) != 0;
    }

    public static boolean isTransient(Member member) {
        return (member.getModifiers() & 0x80) != 0;
    }

    public static boolean isStrict(Member member) {
        return (member.getModifiers() & 0x800) != 0;
    }
}

