/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import rs.baselib.crypto.EncryptionException;
import rs.baselib.crypto.EncryptionUtils;

public class Encrypter {
    private Cipher ecipher;
    private AlgorithmParameterSpec algorithmParameterSpec;

    public Encrypter(Cipher eCipher) {
        this.ecipher = eCipher;
    }

    public Encrypter(Key key, String algorithm) throws EncryptionException {
        this(key, algorithm, null);
    }

    public Encrypter(Key key, String algorithm, AlgorithmParameterSpec paramSpec) throws EncryptionException {
        this.init(key, algorithm, paramSpec);
    }

    public Encrypter(Key key, String algorithm, byte[] salt, int iterationCount) throws EncryptionException {
        this.init(key, algorithm, EncryptionUtils.generateParamSpec(salt, iterationCount));
    }

    public Encrypter(byte[] bytephrase, byte[] salt, int iterationCount) throws EncryptionException, UnsupportedEncodingException {
        try {
            if (iterationCount < 1) {
                iterationCount = 19;
            }
            if (salt == null) {
                salt = EncryptionUtils.generateSalt(0L);
            }
            PBEKeySpec keySpec = new PBEKeySpec(new String(bytephrase, "UTF8").toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.init(key, "PBEWithMD5AndDES", EncryptionUtils.generateParamSpec(salt, iterationCount));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException("Unsupported encoding: " + e.getMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptionException("Invalid key specification: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("No such algorithm: " + e.getMessage(), e);
        }
    }

    public Encrypter(char[] passphrase) throws EncryptionException {
        this(new String(passphrase));
    }

    public Encrypter(char[] passphrase, byte[] salt) throws EncryptionException {
        this(new String(passphrase), salt);
    }

    public Encrypter(String passphrase) throws EncryptionException {
        this(passphrase, null, 0);
    }

    public Encrypter(String passphrase, byte[] salt) throws EncryptionException {
        this(passphrase, salt, 0);
    }

    public Encrypter(String passPhrase, byte[] salt, int iterationCount) throws EncryptionException {
        try {
            if (iterationCount < 1) {
                iterationCount = 19;
            }
            if (salt == null) {
                salt = EncryptionUtils.generateSalt(0L);
            }
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.init(key, null, EncryptionUtils.generateParamSpec(salt, iterationCount));
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptionException("Invalid key specification: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("No such algorithm: " + e.getMessage(), e);
        }
    }

    private void init(Key key, String algorithm, AlgorithmParameterSpec paramSpec) throws EncryptionException {
        try {
            this.algorithmParameterSpec = paramSpec;
            if (algorithm == null) {
                algorithm = key.getAlgorithm();
            }
            this.ecipher = Cipher.getInstance(algorithm);
            if (paramSpec != null) {
                this.ecipher.init(1, key, paramSpec);
            } else {
                this.ecipher.init(1, key);
            }
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("No such padding: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("No such algorithm: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Invalid algorithm: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException("Invalid key: " + e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new EncryptionException("Cannot initialize Encrypter: " + t.getMessage(), t);
        }
    }

    public String getAlgorithm() {
        return this.ecipher.getAlgorithm();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public String encrypt(String str) throws EncryptionException {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.encodeBase64String((byte[])enc).trim();
        }
        catch (Throwable t) {
            throw new EncryptionException("Cannot encrypt string: " + t.getMessage(), t);
        }
    }

    public byte[] encrypt(byte[] bytes) throws EncryptionException {
        try {
            return this.ecipher.doFinal(bytes);
        }
        catch (Throwable t) {
            throw new EncryptionException("Cannot encrypt: " + t.getMessage(), t);
        }
    }
}

