/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import rs.baselib.crypto.BlowfishPasswordHasher;
import rs.baselib.crypto.DummyPasswordHasher;
import rs.baselib.crypto.ExtendedPasswordHasher;
import rs.baselib.crypto.Md5PasswordHasher;
import rs.baselib.crypto.PasswordHasher;
import rs.baselib.crypto.PhpPasswordHasher;
import rs.baselib.crypto.Sha256PasswordHasher;
import rs.baselib.crypto.Sha512PasswordHasher;

public class CombinedPasswordHasher
implements PasswordHasher {
    public static final PasswordHasher UNIX_STRATEGY_MD5 = new CombinedPasswordHasher(Md5PasswordHasher.INSTANCE, BlowfishPasswordHasher.INSTANCE, PhpPasswordHasher.INSTANCE, Sha512PasswordHasher.INSTANCE, Sha256PasswordHasher.INSTANCE, DummyPasswordHasher.INSTANCE);
    public static final PasswordHasher UNIX_STRATEGY_BLOWFISH = new CombinedPasswordHasher(BlowfishPasswordHasher.INSTANCE, Md5PasswordHasher.INSTANCE, PhpPasswordHasher.INSTANCE, Sha512PasswordHasher.INSTANCE, Sha256PasswordHasher.INSTANCE, DummyPasswordHasher.INSTANCE);
    public static final PasswordHasher UNIX_STRATEGY_PHP = new CombinedPasswordHasher(PhpPasswordHasher.INSTANCE, Md5PasswordHasher.INSTANCE, BlowfishPasswordHasher.INSTANCE, Sha512PasswordHasher.INSTANCE, Sha256PasswordHasher.INSTANCE, DummyPasswordHasher.INSTANCE);
    public static final PasswordHasher UNIX_STRATEGY_SHA512 = new CombinedPasswordHasher(Sha512PasswordHasher.INSTANCE, Md5PasswordHasher.INSTANCE, BlowfishPasswordHasher.INSTANCE, PhpPasswordHasher.INSTANCE, Sha256PasswordHasher.INSTANCE, DummyPasswordHasher.INSTANCE);
    public static final PasswordHasher UNIX_STRATEGY_SHA256 = new CombinedPasswordHasher(Sha256PasswordHasher.INSTANCE, Md5PasswordHasher.INSTANCE, BlowfishPasswordHasher.INSTANCE, PhpPasswordHasher.INSTANCE, Sha512PasswordHasher.INSTANCE, DummyPasswordHasher.INSTANCE);
    private ExtendedPasswordHasher[] passwordHashers = null;

    public CombinedPasswordHasher(ExtendedPasswordHasher ... passwordHashers) {
        if (passwordHashers == null || passwordHashers.length == 0) {
            throw new IllegalArgumentException("No hashers given");
        }
        this.passwordHashers = passwordHashers;
    }

    @Override
    public String getPasswordHash(String plainPassword) {
        return this.getDefaultPasswordHasher().getPasswordHash(plainPassword);
    }

    @Override
    public boolean testPassword(String plainPassword, String passwordHash) {
        for (ExtendedPasswordHasher hasher : this.passwordHashers) {
            if (!hasher.isHash(passwordHash)) continue;
            return hasher.testPassword(plainPassword, passwordHash);
        }
        return false;
    }

    public ExtendedPasswordHasher[] getPasswordHashers() {
        return this.passwordHashers;
    }

    public ExtendedPasswordHasher getDefaultPasswordHasher() {
        return this.passwordHashers[0];
    }
}

