/*
 * Decompiled with CFR 0.152.
 */
package eu.prismacapacity.cryptoshred.spring.boot.autoconfiguration;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.prismacapacity.cryptoshred.core.CryptoAlgorithm;
import eu.prismacapacity.cryptoshred.core.CryptoEngine;
import eu.prismacapacity.cryptoshred.core.CryptoInitializationVector;
import eu.prismacapacity.cryptoshred.core.CryptoModule;
import eu.prismacapacity.cryptoshred.core.JDKCryptoEngine;
import eu.prismacapacity.cryptoshred.core.keys.CryptoKeyRepository;
import eu.prismacapacity.cryptoshred.core.keys.CryptoKeySize;
import eu.prismacapacity.cryptoshred.core.metrics.CryptoMetrics;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CryptoShredConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CryptoModule cryptoModule(@Value(value="${cryptoshred.defaults.algorithm:AES}") @NonNull String algo, @Value(value="${cryptoshred.defaults.keySize:256}") int size, @NonNull CryptoKeyRepository repository, @NonNull CryptoEngine engine, @Autowired(required=false) CryptoMetrics metrics) {
        Objects.requireNonNull(algo, "algo is marked non-null but is null");
        Objects.requireNonNull(repository, "repository is marked non-null but is null");
        Objects.requireNonNull(engine, "engine is marked non-null but is null");
        if (metrics == null) {
            metrics = new CryptoMetrics.NOP();
        }
        return new CryptoModule(engine, repository, CryptoAlgorithm.of((String)algo), CryptoKeySize.of((int)size), metrics);
    }

    @Bean
    @ConditionalOnMissingBean
    public CryptoEngine cryptoEngine(@Value(value="${cryptoshred.initVector:#{null}}") String initVector) {
        if (initVector == null || initVector.length() < 1) {
            throw new CryptoPropertyMissingException("cryptoshred.initVector (non-empty String) is required unless you define a CryptoEngine.");
        }
        return new JDKCryptoEngine(CryptoInitializationVector.of((String)initVector));
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper(CryptoModule cm) {
        return new ObjectMapper().registerModule((Module)cm);
    }

    public static class CryptoPropertyMissingException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public CryptoPropertyMissingException(@NonNull String string) {
            super(string);
            Objects.requireNonNull(string, "string is marked non-null but is null");
        }
    }
}

