/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl.rdf4j;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.TriplesMap;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class RDF4JConfiguration
implements LibConfiguration {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private Class<Resource> res = Resource.class;
    private Class<Statement> trpl = Statement.class;
    private Class<Model> graph = Model.class;

    public Resource createResource(String iri) {
        return this.vf.createIRI(iri);
    }

    public Resource createBNode() {
        return this.vf.createBNode();
    }

    public Statement createTriple(Object subject, Object predicate, Object object) {
        return this.vf.createStatement((Resource)subject, (IRI)predicate, (Value)((Resource)object));
    }

    public Statement createLiteralTriple(Object subject, Object predicate, String litObject) {
        return this.vf.createStatement((Resource)subject, (IRI)predicate, (Value)this.vf.createLiteral(litObject));
    }

    public Object createGraph(Collection<TriplesMap> maps) {
        LinkedHashModel m = new LinkedHashModel();
        m.setNamespace("rr", "http://www.w3.org/ns/r2rml#");
        for (TriplesMap tm : maps) {
            m.addAll((Collection)tm.serialize(Statement.class));
        }
        return m;
    }

    public Resource getRDFType() {
        return RDF.TYPE;
    }

    public Collection<Object> getSubjects(Object graph, Object pred, Object obj) {
        Model m = ((Model)graph).filter(null, (IRI)pred, (Value)obj, new Resource[]{null});
        HashSet<Object> c = new HashSet<Object>();
        c.addAll(m.subjects());
        return c;
    }

    public Collection<Object> getObjects(Object graph, Object subj, Object pred) {
        Model m = ((Model)graph).filter((Resource)subj, (IRI)pred, null, new Resource[]{null});
        HashSet<Object> c = new HashSet<Object>();
        for (Value v : m.objects()) {
            if (v instanceof Literal) {
                Literal l = (Literal)v;
                c.add(l.stringValue());
                continue;
            }
            c.add(v);
        }
        return c;
    }

    public Class<Resource> getResourceClass() {
        return this.res;
    }

    public Class<Statement> getTripleClass() {
        return this.trpl;
    }

    public Class<Model> getGraphClass() {
        return this.graph;
    }

    public String getLexicalForm(Object node) {
        return node.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.trpl == null ? 0 : this.trpl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDF4JConfiguration)) {
            return false;
        }
        RDF4JConfiguration other = (RDF4JConfiguration)obj;
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.trpl == null ? other.trpl != null : !this.trpl.equals(other.trpl));
    }
}

