/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl.owlapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.turtle.parser.OWLAPIInternalTurtleParser;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OWLAPIUtil {
    public static void writeTurtle(OutputStream os, Set<RDFTriple> s) throws IOException {
        for (RDFTriple tr : s) {
            os.write(tr.getSubject().toString().getBytes());
            os.write(" ".getBytes());
            os.write(tr.getPredicate().toString().getBytes());
            os.write(" ".getBytes());
            String o = tr.getObject().toString();
            while (o.startsWith("<<")) {
                o = o.substring(1);
            }
            while (o.endsWith(">>")) {
                o = o.substring(0, o.length() - 1);
            }
            os.write(o.getBytes());
            os.write(" .\n".getBytes());
        }
        os.close();
    }

    public static Set<RDFTriple> readTurtle(InputStream is) throws OWLOntologyCreationException, IOException {
        HashSet<RDFTriple> s = new HashSet<RDFTriple>();
        IRI base = IRI.create((String)"http://example.com/base/");
        OWLAPIInternalTurtleParser tp = new OWLAPIInternalTurtleParser(is, new RDFConsAdapter(s), base);
        tp.parse();
        return s;
    }

    @Deprecated
    public static Set<RDFTriple> readRDFXML(InputSource is) throws SAXException, IOException {
        HashSet<RDFTriple> s = new HashSet<RDFTriple>();
        RDFParser r = new RDFParser();
        r.parse(is, (RDFConsumer)new RDFConsAdapter(s));
        return s;
    }

    private static class RDFConsAdapter
    implements RDFConsumer,
    TripleHandler {
        Set<RDFTriple> read;

        RDFConsAdapter(Set<RDFTriple> s) {
            this.read = s;
        }

        public void startModel(@Nonnull IRI physicalURI) {
        }

        public void endModel() {
        }

        public void includeModel(String logicalURI, String physicalURI) {
        }

        @Nonnull
        public IRI remapIRI(@Nonnull IRI i) {
            return null;
        }

        @Nonnull
        public String remapOnlyIfRemapped(@Nonnull String i) {
            return null;
        }

        public void addPrefix(String abbreviation, String value) {
        }

        public void statementWithLiteralValue(String subject, String predicate, String object, String language, String datatype) {
            RDFResource s = this.getRDFResourceFromString(subject);
            RDFResourceIRI p = new RDFResourceIRI(IRI.create((String)predicate));
            IRI datatypeIRI = null;
            if (datatype != null) {
                datatypeIRI = IRI.create((String)datatype);
            }
            RDFLiteral o = new RDFLiteral(object, language, datatypeIRI);
            RDFTriple triple = new RDFTriple(s, p, (RDFNode)o);
            this.read.add(triple);
        }

        private RDFResource getRDFResourceFromString(String subject) {
            if (subject.startsWith("_:")) {
                return new RDFResourceBlankNode(IRI.create((String)subject), true, true);
            }
            return new RDFResourceIRI(IRI.create((String)subject));
        }

        public void statementWithLiteralValue(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull String object, String language, IRI datatype) {
            RDFResourceIRI s = new RDFResourceIRI(subject);
            RDFResourceIRI p = new RDFResourceIRI(predicate);
            RDFLiteral o = new RDFLiteral(object, language, datatype);
            RDFTriple triple = new RDFTriple((RDFResource)s, p, (RDFNode)o);
            this.read.add(triple);
        }

        public void logicalURI(@Nonnull IRI logicalURI) {
        }

        public void statementWithResourceValue(String subject, String predicate, String object) {
            RDFResource s = this.getRDFResourceFromString(subject);
            RDFResourceIRI p = new RDFResourceIRI(IRI.create((String)predicate));
            RDFResource o = this.getRDFResourceFromString(object);
            RDFTriple triple = new RDFTriple(s, p, (RDFNode)o);
            this.read.add(triple);
        }

        public void statementWithResourceValue(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
        }

        public void handleComment(String comment) {
        }

        public void handleEnd() {
        }

        public void handlePrefixDirective(String prefixName, String prefix) {
        }

        public void handleBaseDirective(IRI base) {
        }

        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.statementWithResourceValue(subject.toString(), predicate.toString(), object.toString());
        }

        public void handleTriple(IRI subject, IRI predicate, String object) {
            this.statementWithLiteralValue(subject.toString(), predicate.toString(), object, "", null);
        }

        public void handleTriple(IRI subject, IRI predicate, String object, String lang) {
            this.statementWithLiteralValue(subject.toString(), predicate.toString(), object, lang, null);
        }

        public void handleTriple(IRI subject, IRI predicate, String object, IRI datatype) {
            this.statementWithLiteralValue(subject.toString(), predicate.toString(), object, "", datatype.toString());
        }
    }
}

