/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl.owlapi;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.TriplesMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLAPIConfiguration
implements LibConfiguration {
    OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    OWLDataFactory factory = this.manager.getOWLDataFactory();
    private Class<RDFResource> res = RDFResource.class;
    private Class<RDFTriple> trpl = RDFTriple.class;
    private Class<Set<RDFTriple>> graph = Set.class;

    public RDFResource createResource(String URI) {
        return new RDFResourceIRI(IRI.create((String)URI));
    }

    public RDFResource createBNode() {
        String s = this.factory.getOWLAnonymousIndividual().getID().getID();
        int id = Integer.parseInt(s.replaceFirst("(\\D*)((^\\d)*)", ""));
        return new RDFResourceBlankNode(id, true, true);
    }

    public RDFTriple createTriple(Object subject, Object predicate, Object object) {
        RDFResource s = (RDFResource)subject;
        RDFResourceIRI p = (RDFResourceIRI)predicate;
        RDFResource o = (RDFResource)object;
        return new RDFTriple(s, p, (RDFNode)o);
    }

    public RDFTriple createLiteralTriple(Object subject, Object predicate, String litObject) {
        RDFResource s = (RDFResource)subject;
        RDFResourceIRI p = (RDFResourceIRI)predicate;
        RDFLiteral lit = new RDFLiteral(litObject, "", (IRI)null);
        return new RDFTriple(s, p, (RDFNode)lit);
    }

    public Object createGraph(Collection<TriplesMap> maps) {
        HashSet<RDFTriple> s = new HashSet<RDFTriple>();
        for (TriplesMap tm : maps) {
            Set stmts = tm.serialize(RDFTriple.class);
            for (RDFTriple tr : stmts) {
                s.add(tr);
            }
        }
        return s;
    }

    public RDFResource getRDFType() {
        return this.createResource(OWLRDFVocabulary.RDF_TYPE.getIRI().toString());
    }

    public Collection<Object> getSubjects(Object graph, Object pred, Object obj) {
        Set s = (Set)graph;
        HashSet<Object> c = new HashSet<Object>();
        for (RDFTriple t : s) {
            if (pred != null && !t.getPredicate().equals(pred) || obj != null && !t.getObject().equals(obj)) continue;
            c.add(t.getSubject());
        }
        return c;
    }

    public Collection<Object> getObjects(Object graph, Object subj, Object pred) {
        Set s = (Set)graph;
        HashSet<Object> c = new HashSet<Object>();
        for (RDFTriple t : s) {
            if (subj != null && !t.getSubject().equals(subj) || pred != null && !t.getPredicate().equals(pred)) continue;
            if (t.getObject() instanceof RDFLiteral) {
                c.add(((RDFLiteral)t.getObject()).getLexicalValue());
                continue;
            }
            c.add(t.getObject());
        }
        return c;
    }

    public Class<RDFResource> getResourceClass() {
        return this.res;
    }

    public Class<RDFTriple> getTripleClass() {
        return this.trpl;
    }

    public Class<Set<RDFTriple>> getGraphClass() {
        return this.graph;
    }

    public String getLexicalForm(Object node) {
        if (node instanceof RDFResourceIRI) {
            return ((RDFResourceIRI)node).getIRI().toString();
        }
        return node.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.trpl == null ? 0 : this.trpl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLAPIConfiguration)) {
            return false;
        }
        OWLAPIConfiguration other = (OWLAPIConfiguration)obj;
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.trpl == null ? other.trpl != null : !this.trpl.equals(other.trpl));
    }
}

