/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.util;

import eu.openminted.uc.socialsciences.variabledetection.pipelines.VariableDisambiguationConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class Features2Arff {
    public static final String LF = System.getProperty("line.separator");

    public static void toArffFile(VariableDisambiguationConstants.Mode mode, VariableDisambiguationConstants.Dataset ... datasets) throws IOException {
        for (VariableDisambiguationConstants.Dataset dataset : datasets) {
            String path = "classpath:/goldstandards/semeval-2012/" + mode.toString().toLowerCase() + "/STS.gs." + dataset.toString() + ".txt";
            PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver();
            Resource res = r.getResource(path);
            Features2Arff.toArffFile(mode, dataset, res.getInputStream());
        }
    }

    public static String toArffFile(VariableDisambiguationConstants.Mode mode, VariableDisambiguationConstants.Dataset dataset, InputStream goldStandardInputStream) throws IOException {
        String fileName = "target/models/" + mode.toString().toLowerCase() + "/" + dataset.toString() + ".arff";
        File outFile = new File(fileName);
        Collection files = FileUtils.listFiles((File)new File("target/features/" + mode.toString().toLowerCase() + "/" + (Object)((Object)dataset)), (String[])new String[]{"txt"}, (boolean)true);
        String arffString = Features2Arff.toArffString(files, goldStandardInputStream);
        FileUtils.writeStringToFile((File)outFile, (String)arffString, (Charset)StandardCharsets.UTF_8);
        return fileName;
    }

    private static String toArffString(Collection<File> csvFiles, InputStream goldStandardInputStream) throws IOException {
        StringBuilder arff = new StringBuilder();
        arff.append("@relation temp-relation" + LF);
        arff.append(LF);
        HashMap<Integer, List> data = new HashMap<Integer, List>();
        for (File file : csvFiles) {
            String feature = file.getParentFile().getName() + "/" + file.getName().substring(0, file.getName().length() - 4);
            arff.append("@attribute " + feature + " numeric" + LF);
            List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            if (lines.size() == 0) {
                System.err.println("Empty feature file for " + feature + ". Experiment will probably fail.");
            }
            for (int doc = 1; doc <= lines.size(); ++doc) {
                String line = (String)lines.get(doc - 1);
                if (line.length() <= 0) continue;
                double value = Double.parseDouble(line);
                if (value > 5.0) {
                    value = 5.0;
                }
                if (value < 0.0) {
                    value = 0.0;
                }
                List<Double> docObj = data.containsKey(doc) ? (List)data.get(doc) : new ArrayList<Double>();
                docObj.add(value);
                data.put(doc, docObj);
            }
        }
        arff.append("@attribute gold real" + LF);
        ArrayList<String> lines = new ArrayList<String>();
        if (goldStandardInputStream != null) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(goldStandardInputStream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        } else {
            for (int i = 0; i < FileUtils.readLines((File)csvFiles.iterator().next(), (Charset)StandardCharsets.UTF_8).size(); ++i) {
                lines.add("0.0");
            }
        }
        for (int doc = 1; doc <= lines.size(); ++doc) {
            if (((String)lines.get(doc - 1)).length() == 0) {
                System.out.println("here2");
                break;
            }
            double value = Double.parseDouble((String)lines.get(doc - 1));
            List docObj = (List)data.get(doc);
            docObj.add(value);
            data.put(doc, docObj);
        }
        arff.append(LF);
        arff.append("@data" + LF);
        for (int i = 1; i <= data.keySet().size(); ++i) {
            String dataItem = StringUtils.join((Collection)((Collection)data.get(i)), (String)",");
            arff.append(dataItem + LF);
        }
        return arff.toString();
    }
}

