/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.uima.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VariableFileReader {
    public static Map<String, String> getVariables(InputStream aInputStream) throws IOException {
        HashMap<String, String> variableMap = new HashMap<String, String>();
        DocumentBuilderFactory xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder xmlDocumentBuilder = xmlDocumentBuilderFactory.newDocumentBuilder();
            document = xmlDocumentBuilder.parse(new InputSource(aInputStream));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        if (document != null) {
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList variableNodes = (NodeList)xpath.compile("/variables//variable").evaluate(document, XPathConstants.NODESET);
                for (Node variableNode = variableNodes.item(0); variableNode != null; variableNode = variableNode.getNextSibling()) {
                    if (variableNode.getTextContent().trim().equals("")) continue;
                    NamedNodeMap attributes = variableNode.getAttributes();
                    String variableId = attributes.getNamedItem("v_id").getTextContent().trim();
                    StringBuilder sb = new StringBuilder();
                    Node labelNode = (Node)xpath.compile("./v_label").evaluate(variableNode, XPathConstants.NODE);
                    sb.append(labelNode.getTextContent().trim()).append(" ");
                    Node topicNode = (Node)xpath.compile("./v_topic").evaluate(variableNode, XPathConstants.NODE);
                    if (topicNode != null) {
                        sb.append(topicNode.getTextContent().trim()).append(" ");
                    }
                    Node questionNode = (Node)xpath.compile("./v_question").evaluate(variableNode, XPathConstants.NODE);
                    sb.append(questionNode.getTextContent().trim()).append(" ");
                    Node subquestionNode = (Node)xpath.compile("./v_subquestion").evaluate(variableNode, XPathConstants.NODE);
                    if (subquestionNode != null) {
                        sb.append(subquestionNode.getTextContent().trim()).append(" ");
                    }
                    NodeList answerNodes = (NodeList)xpath.compile("./v_answer").evaluate(variableNode, XPathConstants.NODESET);
                    for (Node answerNode = answerNodes.item(0); answerNode != null; answerNode = answerNode.getNextSibling()) {
                        sb.append(answerNode.getTextContent().trim()).append(" ");
                    }
                    variableMap.put(variableId, sb.toString());
                }
            }
            catch (XPathExpressionException e) {
                throw new IOException("Problem with parsing the expression: " + e.getLocalizedMessage(), e);
            }
        }
        return variableMap;
    }

    private String normalizeWhitespaces(String input) {
        return input.replaceAll("\\s+", " ");
    }
}

