/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.uima.io;

import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.resource.ResourceInitializationException;
import org.dkpro.similarity.uima.io.CombinationReader;
import org.dkpro.similarity.uima.io.util.CombinationPair;

@ResourceMetaData(name="eu.openminted.uc.socialsciences.variabledetection.uima.io.SemEvalCorpusReader", description="Reader for the datasets used in the Semantic Textual Similarity (STS) Task at SemEval-2012\n(Agirre et al., 2012) and *SEM-2013 (Agirre et al., 2013).\n\nAgirre E., Cer D., Diab M., and Gonzalez-Agirre A. (2012). SemEval-2012 Task 6: A Pilot on\nSemantic Textual Similarity. In Proceedings of the 6th International Workshop on Semantic\nEvaluation, in conjunction with the 1st Joint Conference on Lexical and Computational Semantics,\npages 385-393, Montreal, Canada.\n<a href=\"http://aclweb.org/anthology-new/S/S12/S12-1051.pdf\">(pdf)</a>\n\nAgirre E., Cer D., Diab M., Gonzalez-Agirre A., and Guo W. (2013).\n\n*SEM 2013 Shared Task: Semantic Textual Similarity. In Proceedings of the 2nd Joint Conference on\nLexical and Computational Semantics, pages 32-43, Atlanta, GA, USA.\n<a href=\"http://aclweb.org/anthology-new/S/S13/S13-1004.pdf\">(pdf)</a>", version="1.0.1", vendor="OpenMinTeD Project", copyright="Copyright 2016-2018\n                \n                Ubiquitous Knowledge Processing (UKP) Lab\n                Technische Universit\u00e4t Darmstadt\n                \n                GESIS \u2013 Leibniz-Institute for the Social Sciences\n                \n                OpenMinTeD - Open Mining of Text and Data Project http://openminted.eu/")
@EnhancedClassFile
public class SemEvalCorpusReader
extends CombinationReader {
    public static final String PARAM_INPUT_FILES = "inputFiles";
    @ConfigurationParameter(name="inputFiles", mandatory=true)
    private List<String> inputFiles;

    public List<CombinationPair> getAlignedPairs() throws ResourceInitializationException {
        ArrayList<CombinationPair> pairs = new ArrayList<CombinationPair>();
        for (String inputFile : this.inputFiles) {
            URL url;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = null;
            try {
                String strLine;
                url = ResourceUtils.resolveLocation((String)inputFile, (Object)((Object)this), (UimaContext)this.getUimaContext());
                br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((strLine = br.readLine()) != null) {
                    lines.add(strLine);
                }
            }
            catch (IOException e) {
                try {
                    throw new ResourceInitializationException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                String[] linesplit = line.split("\t");
                String text1 = linesplit[0];
                String text2 = linesplit[1];
                CombinationPair pair = new CombinationPair(url.toString());
                pair.setID1(new Integer(i + 1).toString());
                pair.setID2(new Integer(i + 1).toString());
                pair.setText1(text1);
                pair.setText2(text2);
                pairs.add(pair);
            }
        }
        return pairs;
    }
}

