/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.uima;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData;
import de.tudarmstadt.ukp.dkpro.core.api.resources.ModelProviderBase;
import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import eu.openminted.share.annotations.api.Component;
import eu.openminted.uc.socialsciences.variabledetection.features.FeatureGeneration;
import eu.openminted.uc.socialsciences.variabledetection.similarity.LinearRegressionSimilarityMeasure;
import eu.openminted.uc.socialsciences.variabledetection.type.GoldVariableMention;
import eu.openminted.uc.socialsciences.variabledetection.type.VariableMention;
import eu.openminted.uc.socialsciences.variabledetection.uima.io.VariableFileReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import weka.core.Instance;

@Component(value="http://w3id.org/meta-share/omtd-share/VariablesDectector")
@ResourceMetaData(name="Variable Disambiguator", description="Assign variable IDs to sentences based on calculating the similarity between the sentence\ntext and the description of the variable.", version="1.0.1", vendor="OpenMinTeD Project", copyright="Copyright 2016-2018\n                \n                Ubiquitous Knowledge Processing (UKP) Lab\n                Technische Universit\u00e4t Darmstadt\n                \n                GESIS \u2013 Leibniz-Institute for the Social Sciences\n                \n                OpenMinTeD - Open Mining of Text and Data Project http://openminted.eu/")
@TypeCapability(inputs={"de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token", "de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence"}, outputs={"eu.openminted.uc.socialsciences.variabledetection.type.VariableMention.VariableMention"})
@EnhancedClassFile
public class VariableMentionDisambiguator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_LANGUAGE = "language";
    @ConfigurationParameter(name="language", mandatory=false, description="Use this language instead of the document language to resolve the model.")
    private String language;
    public static final String PARAM_VARIANT = "modelVariant";
    @ConfigurationParameter(name="modelVariant", mandatory=false, description="Override the default variant used to locate the model.")
    private String variant;
    public static final String PARAM_MODEL_LOCATION = "modelLocation";
    @ConfigurationParameter(name="modelLocation", mandatory=false, description="Location of the similarity model.")
    private String modelLocation;
    public static final String PARAM_VARIABLE_SPECIFICATION = "variableSpecification";
    @ConfigurationParameter(name="variableSpecification", mandatory=false, description="This parameter accepts an XML string containing the specification of the variables.")
    private String variableSpecification;
    public static final String PARAM_VARIABLE_FILE_LOCATION = "variableFileLocation";
    @ConfigurationParameter(name="variableFileLocation", mandatory=false, description="This parameter accepts a path to an XML file containing the specification of the variables.")
    private String variableFilePath;
    private Map<String, String> variableMap;
    public static final String PARAM_DISAMBIGUATE_ALL_MENTIONS = "disambiguateAllMentions";
    @ConfigurationParameter(name="disambiguateAllMentions", defaultValue={"true"}, description="If set to false, only correct=\"Yes\" mentions are disambiguated, otherwise\nall mentions are disambiguated.")
    private boolean disambiguateAllMentions;
    public static final String PARAM_WRITE_LOG = "writeLog";
    @ConfigurationParameter(name="writeLog", defaultValue={"false"}, description="Whether to write a detailed log of the results. This is mainly useful if gold-data is\nprovided to the component.")
    private boolean writeLog;
    public static final String PARAM_SCORE_THRESHOLD = "scoreThreshold";
    @ConfigurationParameter(name="scoreThreshold", defaultValue={"2.5"}, description="Minimum similarity score to a variable require to count as a match (0-5).")
    private double scoreThreshold;
    public static final String PARAM_MAX_MENTIONS = "maxMentions";
    @ConfigurationParameter(name="maxMentions", defaultValue={"3"}, description="Maximum number of variables linked.")
    private int maxMentions;
    private int[] matchAtRank = new int[100];
    private int[] cumulativeMatchAtRank = new int[100];
    private PrintWriter logwriter;
    private ModelProviderBase<Model> modelProvider;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        block31: {
            super.initialize(context);
            if (this.variableSpecification == null && this.variableFilePath == null) {
                throw new ResourceInitializationException((Throwable)new IllegalArgumentException("Either a variable specification or variable file location must be provided."));
            }
            this.modelProvider = new ModelProviderBase<Model>((Object)this, "variable-detection", "disambiguation"){

                protected Model produceResource(URL aUrl) throws IOException {
                    try {
                        Model model = new Model();
                        model.classifier = VariableMentionDisambiguator.loadClassifier(aUrl.toString() + "/variable-disambiguation/variable-disambiguation-model.ser");
                        model.featureGeneration = new FeatureGeneration(aUrl.toString());
                        return model;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                InputStream is;
                if (this.variableFilePath != null) {
                    is = new FileInputStream(this.variableFilePath);
                    Throwable throwable = null;
                    try {
                        this.variableMap = VariableFileReader.getVariables(is);
                        break block31;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                if (this.variableSpecification == null) break block31;
                is = new ByteArrayInputStream(this.variableSpecification.getBytes(StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    this.variableMap = VariableFileReader.getVariables(is);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
        if (this.writeLog) {
            try {
                this.logwriter = new PrintWriter(new FileWriter("target/log.csv"));
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        DocumentMetaData meta = DocumentMetaData.get((JCas)aJCas);
        this.modelProvider.configure(aJCas.getCas());
        for (Sentence sentence : JCasUtil.select((JCas)aJCas, Sentence.class)) {
            List<Match> matches;
            VariableMention mention;
            List mentions = JCasUtil.selectCovered(VariableMention.class, (AnnotationFS)sentence);
            VariableMention variableMention = mention = mentions.isEmpty() ? null : (VariableMention)((Object)mentions.get(0));
            if (!this.disambiguateAllMentions || mention != null && !"Yes".equals(mention.getCorrect())) continue;
            this.getLogger().info((Object)("Disambiguating variable candidate in [" + sentence.getCoveredText() + "]"));
            try {
                matches = this.getMatches(sentence.getCoveredText(), this.variableMap);
                Collections.sort(matches, (a, b) -> Double.compare(b.score, a.score));
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Disambiguation failed: " + e.getMessage()));
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            int matchCount = 0;
            for (Match match : matches) {
                if (matchCount >= this.maxMentions) break;
                if (match.score < this.scoreThreshold) continue;
                if (mention == null) {
                    mention = new VariableMention(aJCas, sentence.getBegin(), sentence.getEnd());
                    mention.addToIndexes();
                }
                mention.setVariableId(match.id);
                mention.setScore(match.score);
                ++matchCount;
                mention = null;
            }
            HashSet<String> goldVariables = new HashSet<String>();
            for (GoldVariableMention gold : JCasUtil.select((JCas)aJCas, GoldVariableMention.class)) {
                goldVariables.add(gold.getVariableId());
                Match match = matches.stream().filter(m -> gold.getVariableId().equals(m.id)).findFirst().orElse(null);
                if (match == null) {
                    this.getLogger().warn((Object)("Variable ID not found in list [" + gold.getVariableId() + "] - SKIPPING"));
                    continue;
                }
                int rank = matches.indexOf(match);
                if (rank < this.matchAtRank.length) {
                    int n = rank;
                    this.matchAtRank[n] = this.matchAtRank[n] + 1;
                }
                this.getLogger().info((Object)("Gold " + gold.getVariableId() + " at rank " + (rank + 1) + " with score " + match.score));
                for (int i = 0; i < this.cumulativeMatchAtRank.length; ++i) {
                    if (rank > i) continue;
                    int n = i;
                    this.cumulativeMatchAtRank[n] = this.cumulativeMatchAtRank[n] + 1;
                }
            }
            if (!this.writeLog) continue;
            boolean bl = true;
            for (Match m3 : matches) {
                void var10_14;
                this.logwriter.printf("%s;%d;%s;%d;%f;%d%n", meta.getDocumentId(), goldVariables.isEmpty() ? 0 : 1, m3.id, (int)var10_14, m3.score, goldVariables.contains(m3.id) ? 1 : 0);
                ++var10_14;
            }
            this.logwriter.flush();
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.logwriter != null) {
            for (int i = 0; i < this.matchAtRank.length; ++i) {
                this.getLogger().info((Object)("Matches at " + (i + 1) + ": " + this.matchAtRank[i] + " - " + this.cumulativeMatchAtRank[i]));
            }
            this.logwriter.close();
        }
    }

    private static LinearRegressionSimilarityMeasure loadClassifier(String aFilename) throws FileNotFoundException, IOException, ClassNotFoundException {
        LinearRegressionSimilarityMeasure classifier;
        try (ObjectInputStream input = new ObjectInputStream(ResourceUtils.resolveLocation((String)aFilename).openStream());){
            classifier = (LinearRegressionSimilarityMeasure)input.readObject();
        }
        return classifier;
    }

    private List<Match> getMatches(String aSentence, Map<String, String> aVariableMap) throws Exception {
        ArrayList<Match> matches = new ArrayList<Match>();
        Model model = (Model)this.modelProvider.getResource();
        long t = System.currentTimeMillis();
        int i = 0;
        for (String varId : aVariableMap.keySet()) {
            Instance instance = model.featureGeneration.generateFeatures(aSentence, aVariableMap.get(varId), model.classifier.isUseLogFilter());
            double similarity = model.classifier.getSimilarity(instance);
            matches.add(new Match(varId, similarity));
            ++i;
        }
        t = System.currentTimeMillis() - t;
        this.getLogger().debug((Object)String.format(" %d (%d avg per item)%n", t, t / (long)aVariableMap.size()));
        return matches;
    }

    private static class Match {
        final String id;
        final double score;

        public Match(String aId, double aScore) {
            this.id = aId;
            this.score = aScore;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Match [id=");
            builder.append(this.id);
            builder.append(", score=");
            builder.append(this.score);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class Model {
        private LinearRegressionSimilarityMeasure classifier;
        private FeatureGeneration featureGeneration;

        private Model() {
        }
    }
}

