/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.uima;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import eu.openminted.uc.socialsciences.variabledetection.type.GoldVariableMention;
import eu.openminted.uc.socialsciences.variabledetection.type.VariableMention;
import java.io.File;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.dkpro.tc.api.type.TextClassificationOutcome;
import org.dkpro.tc.api.type.TextClassificationTarget;
import org.dkpro.tc.ml.uima.TcAnnotator;

@ResourceMetaData(name="Variable mention tagger", description="Variable detection component", version="1.0.1", vendor="OpenMinTeD Project", copyright="Copyright 2016-2018\n                \n                Ubiquitous Knowledge Processing (UKP) Lab\n                Technische Universit\u00e4t Darmstadt\n                \n                GESIS \u2013 Leibniz-Institute for the Social Sciences\n                \n                OpenMinTeD - Open Mining of Text and Data Project http://openminted.eu/")
@EnhancedClassFile
public class VariableMentionDetector
extends JCasAnnotator_ImplBase {
    public static final String PARAM_MODEL_LOCATION = "modelLocation";
    @ConfigurationParameter(name="modelLocation")
    private File modelLocation;
    private AnalysisEngine taggerEngine = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.taggerEngine = AnalysisEngineFactory.createEngine(TcAnnotator.class, (Object[])new Object[]{"tcModel", this.modelLocation, "unitAnnotation", Sentence.class});
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.getLogger().info((Object)("Detecting variables in [" + aJCas.getDocumentText() + "]"));
        this.taggerEngine.process(aJCas);
        TextClassificationTarget target = (TextClassificationTarget)JCasUtil.selectSingle((JCas)aJCas, TextClassificationTarget.class);
        target.removeFromIndexes();
        for (TextClassificationOutcome outcome : JCasUtil.select((JCas)aJCas, TextClassificationOutcome.class)) {
            VariableMention variableMention = new VariableMention(aJCas, target.getBegin(), target.getEnd());
            variableMention.setCorrect(outcome.getOutcome());
            variableMention.addToIndexes();
            this.getLogger().info((Object)("Detected variable mention: " + variableMention.getCorrect()));
            outcome.removeFromIndexes();
        }
        this.getLogger().info((Object)("Gold variable mention    : " + (JCasUtil.exists((JCas)aJCas, GoldVariableMention.class) ? "Yes" : "No")));
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.taggerEngine != null) {
            this.taggerEngine.collectionProcessComplete();
        }
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        if (this.taggerEngine != null) {
            this.taggerEngine.batchProcessComplete();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.taggerEngine != null) {
            this.taggerEngine.destroy();
        }
    }
}

