/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.similarity;

import java.io.File;
import java.io.Serializable;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.dkpro.similarity.algorithms.api.JCasTextSimilarityMeasureBase;
import org.dkpro.similarity.algorithms.api.SimilarityException;
import org.dkpro.similarity.ml.filters.LogFilter;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;

public class LinearRegressionSimilarityMeasure
extends JCasTextSimilarityMeasureBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Classifier CLASSIFIER = new LinearRegression();
    private Classifier filteredClassifier;
    private boolean useLogFilter;

    public LinearRegressionSimilarityMeasure(File trainArff, boolean aUseLogFilter) throws Exception {
        Instances train = this.getTrainInstances(trainArff);
        this.useLogFilter = aUseLogFilter;
        if (this.useLogFilter) {
            LogFilter logFilter = new LogFilter();
            logFilter.setInputFormat(train);
            train = Filter.useFilter((Instances)train, (Filter)logFilter);
        }
        try {
            Classifier clsCopy;
            this.filteredClassifier = clsCopy = AbstractClassifier.makeCopy((Classifier)CLASSIFIER);
            this.filteredClassifier.buildClassifier(train);
            System.out.println(this.filteredClassifier.toString());
        }
        catch (Exception e) {
            throw new SimilarityException((Throwable)e);
        }
    }

    private Instances getTrainInstances(File trainArff) throws SimilarityException {
        Instances data;
        try {
            data = ConverterUtils.DataSource.read((String)trainArff.getAbsolutePath());
        }
        catch (Exception e) {
            throw new SimilarityException((Throwable)e);
        }
        data.setClassIndex(data.numAttributes() - 1);
        return data;
    }

    public Instance getInstance(File arff) throws Exception {
        Instances instances = this.getTrainInstances(arff);
        if (this.useLogFilter) {
            LogFilter logFilter = new LogFilter();
            logFilter.setInputFormat(instances);
            instances = Filter.useFilter((Instances)instances, (Filter)logFilter);
        }
        return instances.get(0);
    }

    public boolean isUseLogFilter() {
        return this.useLogFilter;
    }

    public double getSimilarity(Instance instance) throws Exception {
        return this.filteredClassifier.classifyInstance(instance);
    }

    public double getSimilarity(JCas jcas1, JCas jcas2, Annotation coveringAnnotation1, Annotation coveringAnnotation2) throws SimilarityException {
        throw new UnsupportedOperationException();
    }
}

