/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.resource;

import eu.openminted.uc.socialsciences.variabledetection.resource.KnowledgeBaseResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.FileManager;

public class TheSozResource
implements KnowledgeBaseResource {
    public static final String NAME = "TheSoz";
    private Model model = ModelFactory.createDefaultModel();
    private final String prefixString;
    private Map<Pair<String, String>, Boolean> cache;
    private final String NO_LANGUAGE = "";

    public TheSozResource(String theSozPath) {
        InputStream in = FileManager.get().open(theSozPath);
        if (in == null) {
            throw new IllegalArgumentException("Can not file TheSoz file: [" + theSozPath + "]");
        }
        this.model.read(in, null);
        this.prefixString = "prefix skos: <http://www.w3.org/2004/02/skos/core#>";
        this.cache = new HashMap<Pair<String, String>, Boolean>();
    }

    @Override
    public boolean containsConceptLabel(String conceptLabel) {
        Optional<Boolean> valueFromCache = this.getFromCache(conceptLabel, "");
        if (valueFromCache.isPresent()) {
            return valueFromCache.get();
        }
        boolean result = false;
        try {
            Query query = this.createSelectQuery(conceptLabel);
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.model);
            ResultSet resultSet = qexec.execSelect();
            result = resultSet.hasNext();
        }
        catch (QueryException ex) {
            System.err.println("Cannot parse query for conceptLabel=[" + conceptLabel + "]");
        }
        this.putInCache(conceptLabel, "", result);
        return result;
    }

    @Override
    public boolean containsConceptLabel(String conceptLabel, String language) {
        Optional<Boolean> valueFromCache = this.getFromCache(conceptLabel, language);
        if (valueFromCache.isPresent()) {
            return valueFromCache.get();
        }
        boolean result = false;
        try {
            Query query = this.createSelectQuery(conceptLabel);
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.model);
            ResultSet resultSet = qexec.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution solution = resultSet.next();
                Literal literal = solution.getLiteral("?label");
                if (literal.getLanguage() == null || !language.equals(literal.getLanguage())) continue;
                result = true;
                break;
            }
        }
        catch (QueryException ex) {
            System.err.println("Cannot parse query for conceptLabel=[" + conceptLabel + "]");
        }
        this.putInCache(conceptLabel, language, result);
        return result;
    }

    private Optional<Boolean> getFromCache(String conceptLabel, String language) {
        MutablePair cacheEntryId = new MutablePair((Object)conceptLabel, (Object)language);
        return Optional.ofNullable(this.cache.get(cacheEntryId));
    }

    private void putInCache(String conceptLabel, String language, boolean value) {
        MutablePair cacheEntryId = new MutablePair((Object)conceptLabel, (Object)language);
        this.cache.put((Pair<String, String>)cacheEntryId, value);
    }

    private Query createSelectQuery(String conceptLabel) throws QueryException {
        Query query = QueryFactory.create((String)(this.prefixString + "SELECT ?label WHERE {      ?term ?p ?label .      FILTER ((?p IN (skos:prefLabel, skos:altLabel))          && str(?label) = \"" + conceptLabel + "\") }"));
        return query;
    }
}

