/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.pipelines;

import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiWriter;
import de.tudarmstadt.ukp.dkpro.core.opennlp.OpenNlpPosTagger;
import de.tudarmstadt.ukp.dkpro.core.stanfordnlp.StanfordLemmatizer;
import de.tudarmstadt.ukp.dkpro.core.stopwordremover.StopWordRemover;
import de.tudarmstadt.ukp.dkpro.core.tokit.BreakIteratorSegmenter;
import eu.openminted.uc.socialsciences.variabledetection.uima.VariableMentionDetector;
import eu.openminted.uc.socialsciences.variabledetection.uima.io.XmlCorpusAllDocsReader;
import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.resource.ResourceInitializationException;
import org.dkpro.tc.core.Constants;

public class DetectionOnlyPipeline
implements Constants {
    private static final String COPRUS_FILEPATH_TEST = "/home/local/UKP/kiaeeha/workspace/Datasets/openminted/uc-ss/variable-detection/detection/Full_ALLDOCS.xml";
    private static final String DETECTION_MODEL_LOCATION = "../data/models/variable-detection/";
    private static final String LANGUAGE_CODE = "en";
    public static final File PREDICTION_PATH = new File("target/prediction");

    public static void main(String[] args) throws Exception {
        DetectionOnlyPipeline experiment = new DetectionOnlyPipeline();
        experiment.applyStoredModel();
    }

    protected void applyStoredModel() throws ResourceInitializationException, UIMAException, IOException {
        CollectionReaderDescription readerTest = CollectionReaderFactory.createReaderDescription(XmlCorpusAllDocsReader.class, (Object[])new Object[]{"sourceLocation", COPRUS_FILEPATH_TEST, "language", LANGUAGE_CODE});
        SimplePipeline.runPipeline((CollectionReaderDescription)readerTest, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{AnalysisEngineFactory.createEngineDescription(BreakIteratorSegmenter.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(OpenNlpPosTagger.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(StanfordLemmatizer.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(StopWordRemover.class, (Object[])new Object[]{"modelLocation", "classpath:/stopwords/english.txt"}), AnalysisEngineFactory.createEngineDescription(VariableMentionDetector.class, (Object[])new Object[]{"modelLocation", DETECTION_MODEL_LOCATION}), AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", PREDICTION_PATH, "overwrite", true})});
    }
}

