/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.pipelines;

import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiWriter;
import de.tudarmstadt.ukp.dkpro.core.opennlp.OpenNlpPosTagger;
import de.tudarmstadt.ukp.dkpro.core.stanfordnlp.StanfordLemmatizer;
import de.tudarmstadt.ukp.dkpro.core.stopwordremover.StopWordRemover;
import de.tudarmstadt.ukp.dkpro.core.tokit.BreakIteratorSegmenter;
import eu.openminted.uc.socialsciences.variabledetection.uima.VariableMentionDisambiguator;
import eu.openminted.uc.socialsciences.variabledetection.uima.io.XmlCorpusAllDocsReader;
import java.io.File;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;

public class DetectionDisambiguationExperiment {
    private static final String DETECTION_MODEL_LOCATION = "classpath:/models/variable-detection/";
    private static final String DISAMBIGUATION_MODEL_LOCATION = "classpath:/models/variable-disambiguation/variable-disambiguation-model.ser";
    private static final String COPRUS_FILEPATH_TEST = "../data/datasets/Full_ALLDOCS_English.xml";
    private static final String LANGUAGE_CODE = "en";
    private static final File PREDICTION_PATH = new File("target/prediction");

    public static void main(String[] args) throws Exception {
        System.setProperty("org.apache.uima.logger.class", "org.apache.uima.util.impl.Log4jLogger_impl");
        SimplePipeline.runPipeline((CollectionReaderDescription)CollectionReaderFactory.createReaderDescription(XmlCorpusAllDocsReader.class, (Object[])new Object[]{"includeGold", true, "sourceLocation", COPRUS_FILEPATH_TEST, "language", LANGUAGE_CODE}), (AnalysisEngineDescription[])new AnalysisEngineDescription[]{AnalysisEngineFactory.createEngineDescription(BreakIteratorSegmenter.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(OpenNlpPosTagger.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(StanfordLemmatizer.class, (Object[])new Object[0]), AnalysisEngineFactory.createEngineDescription(StopWordRemover.class, (Object[])new Object[]{"modelLocation", "classpath:/stopwords/stopwords_english_punctuation.txt"}), AnalysisEngineFactory.createEngineDescription(VariableMentionDisambiguator.class, (Object[])new Object[]{"scoreThreshold", Float.valueOf(3.0f), "maxMentions", 3, "writeLog", true, "disambiguateAllMentions", true, "modelLocation", DISAMBIGUATION_MODEL_LOCATION, "variableFileLocation", "../data/datasets/Variables_English.xml"}), AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", PREDICTION_PATH, "overwrite", true})});
    }
}

