/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.features;

import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import eu.openminted.uc.socialsciences.variabledetection.pipelines.VariableDisambiguationConstants;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dkpro.similarity.algorithms.lexical.ngrams.CharacterNGramMeasure;

public class CharacterNGramIdfValuesGenerator {
    static final String LF = System.getProperty("line.separator");

    public static void computeIdfScores(VariableDisambiguationConstants.Dataset aTarget, VariableDisambiguationConstants.Mode mode, List<VariableDisambiguationConstants.Dataset> datasets, int n) throws Exception {
        ArrayList lines = new ArrayList();
        for (VariableDisambiguationConstants.Dataset dataset : datasets) {
            URL inputUrl = ResourceUtils.resolveLocation((String)("classpath:/datasets/semeval-2012/" + mode.toString().toLowerCase() + "/STS.input." + dataset.toString() + ".txt"));
            lines.addAll(IOUtils.readLines((InputStream)inputUrl.openStream(), (String)"utf-8"));
        }
        System.out.println("Computing character " + n + "-grams");
        File outputFile = new File("../data/utils/character-ngrams-idf/" + mode.toString().toLowerCase() + "/" + n + "/" + (Object)((Object)aTarget) + ".txt");
        if (outputFile.exists()) {
            System.out.println(" - skipping, already exists");
        } else {
            HashMap<String, Double> idfValues = new HashMap<String, Double>();
            CharacterNGramMeasure measure = new CharacterNGramMeasure(n, new HashMap());
            ArrayList<Set> docs = new ArrayList<Set>();
            for (Iterator<Object> line : lines) {
                Set ngrams = measure.getNGrams((String)((Object)line));
                docs.add(ngrams);
            }
            HashSet allNGrams = new HashSet();
            for (Set doc : docs) {
                allNGrams.addAll(doc);
            }
            for (String ngram : allNGrams) {
                double count = 0.0;
                for (Set doc : docs) {
                    if (!doc.contains(ngram)) continue;
                    count += 1.0;
                }
                idfValues.put(ngram, count);
            }
            for (String lemma : idfValues.keySet()) {
                double idf = Math.log10((double)lines.size() / (Double)idfValues.get(lemma));
                idfValues.put(lemma, idf);
            }
            StringBuilder sb = new StringBuilder();
            for (String key : idfValues.keySet()) {
                sb.append(key + "\t" + idfValues.get(key) + LF);
            }
            FileUtils.writeStringToFile((File)outputFile, (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
            System.out.println(" - done");
        }
    }
}

