/*
 * Decompiled with CFR 0.152.
 */
package eu.openminted.uc.socialsciences.variabledetection.eval;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData;
import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiReader;
import eu.openminted.uc.socialsciences.common.evaluation.FMeasure;
import eu.openminted.uc.socialsciences.variabledetection.type.VariableMention;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;

public class PerformanceMeasure {
    private static final Logger logger = LogManager.getLogger(PerformanceMeasure.class);
    private String inputGold;
    private String inputPrediction;
    private boolean strictId = false;
    private boolean verbose = false;
    private FMeasure fMeasure = new FMeasure();

    public static void main(String[] args) throws ResourceInitializationException {
        new PerformanceMeasure().run(args);
    }

    public void run() throws ResourceInitializationException {
        this.assertFields();
        this.runInternal();
    }

    private void assertFields() {
        if (this.inputGold == null) {
            throw new IllegalArgumentException("inputGold can not be null.");
        }
        if (this.inputPrediction == null) {
            throw new IllegalArgumentException("InputPrediction can not be null.");
        }
    }

    private void run(String[] args) throws ResourceInitializationException {
        this.inputGold = args[0];
        this.inputPrediction = args[1];
        this.runInternal();
    }

    private void runInternal() throws ResourceInitializationException {
        logger.info((Object)String.format("Gold path: %s", this.inputGold));
        Map<String, JCas> goldJcasMap = PerformanceMeasure.getJcases(this.inputGold, this.strictId);
        logger.info((Object)String.format("Found [%d] documents in gold document path.", goldJcasMap.size()));
        logger.info((Object)String.format("Prediction path: %s", this.inputPrediction));
        Map<String, JCas> predictionJcasMap = PerformanceMeasure.getJcases(this.inputPrediction, this.strictId);
        logger.info((Object)String.format("Found [%d] documents in prediction document path.", predictionJcasMap.size()));
        for (String key : goldJcasMap.keySet()) {
            if (!predictionJcasMap.containsKey(key)) {
                logger.error((Object)("Couldn't find document [" + key + "] in prediction set."));
                continue;
            }
            System.out.printf("%nCalculating precision/recall scores for doc [%s]%n", key);
            this.calculatePrecision(goldJcasMap.get(key), predictionJcasMap.get(key), this.verbose);
        }
    }

    public void calculatePrecision(JCas goldJcas, JCas predictionJcas, boolean verbose) {
        ArrayList<VariableAnnotation> goldAnnotations = new ArrayList<VariableAnnotation>();
        ArrayList<VariableAnnotation> predictedAnnotations = new ArrayList<VariableAnnotation>();
        for (VariableMention mention : JCasUtil.select((JCas)goldJcas, VariableMention.class)) {
            if (!mention.getCorrect().equals("Yes")) continue;
            goldAnnotations.add(new VariableAnnotation(mention.getVariableId(), mention.getBegin(), mention.getEnd()));
        }
        for (VariableMention mention : JCasUtil.select((JCas)predictionJcas, VariableMention.class)) {
            if (!mention.getCorrect().equals("Yes")) continue;
            predictedAnnotations.add(new VariableAnnotation(mention.getVariableId(), mention.getBegin(), mention.getEnd()));
        }
        int hitCount = this.fMeasure.process(goldAnnotations, predictedAnnotations);
        if (verbose) {
            System.out.printf("Total annotations in gold file: %d%n", goldAnnotations.size());
            System.out.printf("Intersection of annotations found in gold and prediction file: %d%n", hitCount);
        }
        System.out.printf("FMeasure scores%n", new Object[0]);
        System.out.printf("\tOverall precision: %f %n", this.fMeasure.getPrecision());
        System.out.printf("\tOverall recall: %f %n", this.fMeasure.getRecall());
        System.out.printf("\tOverall F-Measure: %f %n", this.fMeasure.getFMeasure());
    }

    public static Map<String, JCas> getJcases(String documentPathPattern, boolean strictId) throws ResourceInitializationException {
        CollectionReaderDescription reader = CollectionReaderFactory.createReaderDescription(XmiReader.class, (Object[])new Object[]{"sourceLocation", documentPathPattern, "patterns", "[+]**/*.xmi", "lenient", false});
        HashMap<String, JCas> result = new HashMap<String, JCas>();
        int count = 0;
        for (JCas jcas : SimplePipeline.iteratePipeline((CollectionReaderDescription)reader, (AnalysisEngineDescription[])new AnalysisEngineDescription[0])) {
            JCas myjcas;
            String id;
            ++count;
            if (!strictId) {
                id = Integer.toString(count);
            } else {
                DocumentMetaData metadata = DocumentMetaData.get((JCas)jcas);
                id = metadata.getDocumentId();
            }
            try {
                myjcas = JCasFactory.createJCas();
            }
            catch (UIMAException e) {
                logger.error((Object)"An error occurred while trying to create a new JCas", (Throwable)e);
                throw new IllegalStateException(e);
            }
            CasCopier.copyCas((CAS)jcas.getCas(), (CAS)myjcas.getCas(), (boolean)true);
            result.put(id, myjcas);
        }
        return result;
    }

    public void setInputGold(String inputGold) {
        this.inputGold = inputGold;
    }

    public String getInputGold() {
        return this.inputGold;
    }

    public void setInputPrediction(String inputPrediction) {
        this.inputPrediction = inputPrediction;
    }

    public String getInputPrediction() {
        return this.inputPrediction;
    }

    public void setStrictId(boolean value) {
        this.strictId = value;
    }

    public boolean isStrictId() {
        return this.strictId;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private static class VariableAnnotation {
        private final String id;
        private final int begin;
        private final int length;

        VariableAnnotation(String aId, int begin, int length) {
            this.id = aId;
            this.begin = begin;
            this.length = length;
        }

        public String getType() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableAnnotation that = (VariableAnnotation)o;
            return this.begin == that.begin && this.length == that.length && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.begin, this.length);
        }
    }
}

