/*
 * Decompiled with CFR 0.152.
 */
package com.mindfusion.drawing;

import com.mindfusion.common.Serialization;
import com.mindfusion.drawing.Brush;
import com.mindfusion.drawing.Colors;
import com.mindfusion.drawing.ExternalizableImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TextureBrush
extends Brush {
    private BufferedImage a;
    private Rectangle2D c;

    public TextureBrush() {
        this.a = null;
        this.c = new Rectangle2D.Double();
    }

    public TextureBrush(Image image) {
        this.setTexture(image);
    }

    @Override
    public void applyTo(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.a != null) {
            float f2 = (float)graphics2D.getTransform().getScaleX();
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), this.c.getWidth() / (double)f2, this.c.getHeight() / (double)f2);
            graphics2D.setPaint(new TexturePaint(this.a, double_));
        }
    }

    @Override
    public TextureBrush clone() {
        TextureBrush textureBrush = new TextureBrush();
        textureBrush.a = this.a;
        textureBrush.c = (Rectangle2D)this.c.clone();
        return textureBrush;
    }

    public Image getTexture() {
        return this.a;
    }

    public void setTexture(Image image) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        this.a = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = this.a.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.c = new Rectangle2D.Double(0.0, 0.0, n2, n3);
    }

    @Override
    public Color toColor() {
        return Colors.Black;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(ExternalizableImage.getExImage(this.a));
        Serialization.writeRect(objectOutput, this.c);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.a = (BufferedImage)((ExternalizableImage)objectInput.readObject()).getImage();
        this.c = Serialization.readRect(objectInput);
    }
}

