/*
 * Decompiled with CFR 0.152.
 */
package com.mindfusion.common;

import com.mindfusion.common.DateTime;
import com.mindfusion.common.ObservableListListener;
import com.mindfusion.scheduling.ViewSettings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.EventListenerList;

public class ObservableList<E>
extends AbstractList<E>
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected ArrayList<E> list;
    private final EventListenerList a = new EventListenerList();

    public ObservableList() {
        this.list = new ArrayList();
    }

    public ObservableList(int n2) {
        this.list = new ArrayList(n2);
    }

    public ObservableList(Collection<E> collection) {
        this.list = new ArrayList<E>(collection);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int n2) {
        return this.list.get(n2);
    }

    @Override
    public E set(int n2, E e2) {
        E e3 = this.list.set(n2, e2);
        this.fireReplaced(e3, e2);
        return e3;
    }

    @Override
    public void add(int n2, E e2) {
        this.list.add(n2, e2);
        this.fireAdded(e2);
    }

    @Override
    public E remove(int n2) {
        E e2 = this.list.remove(n2);
        this.fireRemoved(e2);
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        if (this.list.remove(object)) {
            this.fireRemoved(object);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n2 = this.list.size();
        objectOutput.writeInt(n2);
        ViewSettings[] viewSettingsArray = DateTime.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutput.writeObject(this.list.get(i2));
            if (viewSettingsArray == null) continue;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.list.clear();
        int n2 = objectInput.readInt();
        ViewSettings[] viewSettingsArray = DateTime.b();
        this.list.ensureCapacity(n2);
        ViewSettings[] viewSettingsArray2 = viewSettingsArray;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.list.add(objectInput.readObject());
            if (viewSettingsArray2 == null) continue;
        }
    }

    public void addListListener(ObservableListListener<E> observableListListener) {
        this.a.add(ObservableListListener.class, observableListListener);
    }

    public void removeListListener(ObservableListListener<E> observableListListener) {
        this.a.remove(ObservableListListener.class, observableListListener);
    }

    protected void fireReplaced(E e2, E e3) {
        ObservableListListener[] observableListListenerArray = (ObservableListListener[])this.a.getListeners(ObservableListListener.class);
        int n2 = observableListListenerArray.length;
        ViewSettings[] viewSettingsArray = DateTime.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            ObservableListListener observableListListener = observableListListenerArray[i2];
            observableListListener.elementRemoved(e2);
            observableListListener.elementAdded(e3);
            if (viewSettingsArray == null) continue;
        }
    }

    protected void fireAdded(E e2) {
        ObservableListListener[] observableListListenerArray = (ObservableListListener[])this.a.getListeners(ObservableListListener.class);
        int n2 = observableListListenerArray.length;
        ViewSettings[] viewSettingsArray = DateTime.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            ObservableListListener observableListListener = observableListListenerArray[i2];
            observableListListener.elementAdded(e2);
            if (viewSettingsArray == null) continue;
        }
    }

    protected void fireRemoved(E e2) {
        ObservableListListener[] observableListListenerArray = (ObservableListListener[])this.a.getListeners(ObservableListListener.class);
        int n2 = observableListListenerArray.length;
        ViewSettings[] viewSettingsArray = DateTime.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            ObservableListListener observableListListener = observableListListenerArray[i2];
            observableListListener.elementRemoved(e2);
            if (viewSettingsArray == null) continue;
        }
    }
}

