/*
 * Decompiled with CFR 0.152.
 */
package com.mindfusion.common;

import com.mindfusion.common.OverflowException;

public class Duration
implements Comparable<Duration>,
Cloneable {
    public static final long TicksPerMillisecond = 10000L;
    public static final long TicksPerSecond = 10000000L;
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerHour = 36000000000L;
    public static final long TicksPerDay = 864000000000L;
    static final double a = 1.0E-4;
    static final double b = 1.0E-7;
    static final double c = 1.6666666666666667E-9;
    static final double d = 2.7777777777777777E-11;
    static final double e = 1.1574074074074074E-12;
    static final int f = 1000;
    static final int g = 60000;
    static final int h = 3600000;
    static final int i = 86400000;
    static final long j = 922337203685477L;
    static final long k = -922337203685477L;
    public static final Duration Zero = new Duration(0L);
    public static final Duration MaxValue = new Duration(Long.MAX_VALUE);
    public static final Duration MinValue = new Duration(Long.MIN_VALUE);
    long l;

    public Duration() {
    }

    public Duration(long l2) {
        this.l = l2;
    }

    public Duration(int n2, int n3, int n4) {
        this(0, n2, n3, n4, 0);
    }

    public Duration(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0);
    }

    public Duration(int n2, int n3, int n4, int n5, int n6) {
        long l2;
        block4: {
            l2 = ((((long)n2 * 24L + (long)n3) * 60L + (long)n4) * 60L + (long)n5) * 1000L + (long)n6;
            try {
                try {
                    if (l2 <= 922337203685477L && l2 >= -922337203685477L) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        this.l = l2 * 10000L;
    }

    public Duration clone() {
        return new Duration(this.l);
    }

    @Override
    public int compareTo(Duration duration) {
        try {
            if (this.l > duration.l) {
                return 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        try {
            if (this.l < duration.l) {
                return -1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!(object instanceof Duration) || this.l != ((Duration)object).l) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw Duration.b(illegalArgumentException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public int hashCode() {
        return (int)this.l ^ (int)(this.l >> 32);
    }

    public String toString() {
        return this.getDays() + "." + this.getHours() + ':' + this.getMinutes() + ':' + this.getSeconds() + '.' + this.getMilliseconds();
    }

    public static Duration fromTicks(long l2) {
        return new Duration(l2);
    }

    public static Duration fromMilliseconds(double d2) {
        return Duration.a(d2, 1);
    }

    public static Duration fromSeconds(double d2) {
        return Duration.a(d2, 1000);
    }

    public static Duration fromMinutes(double d2) {
        return Duration.a(d2, 60000);
    }

    public static Duration fromHours(double d2) {
        return Duration.a(d2, 3600000);
    }

    public static Duration fromDays(double d2) {
        return Duration.a(d2, 86400000);
    }

    private static Duration a(double d2, int n2) {
        double d3;
        double d4;
        try {
            if (Double.isNaN(d2)) {
                return Zero;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        double d5 = d2 * (double)n2;
        try {
            d4 = d5;
            d3 = d2 >= 0.0 ? 0.5 : -0.5;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        double d6 = d4 + d3;
        try {
            if (d6 > 9.22337203685477E14) {
                return MaxValue;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        try {
            if (d6 < -9.22337203685477E14) {
                return MinValue;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return new Duration((long)d6 * 10000L);
    }

    public Duration add(Duration duration) {
        long l2;
        block7: {
            try {
                if (duration == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
            l2 = this.l + duration.l;
            try {
                try {
                    if (this.l >> 63 != duration.l >> 63 || this.l >> 63 == l2 >> 63) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new OverflowException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        return new Duration(l2);
    }

    public Duration subtract(Duration duration) {
        long l2;
        block7: {
            try {
                if (duration == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
            l2 = this.l - duration.l;
            try {
                try {
                    if (this.l >> 63 == duration.l >> 63 || this.l >> 63 == l2 >> 63) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new OverflowException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        return new Duration(l2);
    }

    public Duration negate() {
        try {
            if (this.l == Duration.MinValue.l) {
                throw new OverflowException();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return new Duration(-this.l);
    }

    public static Duration op_UnaryNegation(Duration duration) {
        try {
            if (duration == null) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return duration.negate();
    }

    public static Duration op_Subtraction(Duration duration, Duration duration2) {
        block4: {
            try {
                try {
                    if (duration != null && duration2 != null) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        return duration.subtract(duration2);
    }

    public static Duration op_Addition(Duration duration, Duration duration2) {
        block4: {
            try {
                try {
                    if (duration != null && duration2 != null) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        return duration.add(duration2);
    }

    public static boolean op_Equality(Duration duration, Duration duration2) {
        boolean bl2;
        block8: {
            boolean bl3;
            block10: {
                block9: {
                    try {
                        try {
                            try {
                                if (duration != null && duration2 != null) break block8;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw Duration.b(illegalArgumentException);
                            }
                            if (duration != duration2) break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw Duration.b(illegalArgumentException);
                        }
                        bl3 = true;
                        break block10;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw Duration.b(illegalArgumentException);
                    }
                }
                bl3 = false;
            }
            return bl3;
        }
        try {
            bl2 = duration.l == duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public static boolean op_Inequality(Duration duration, Duration duration2) {
        boolean bl2;
        block8: {
            boolean bl3;
            block10: {
                block9: {
                    try {
                        try {
                            try {
                                if (duration != null && duration2 != null) break block8;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw Duration.b(illegalArgumentException);
                            }
                            if (duration == duration2) break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw Duration.b(illegalArgumentException);
                        }
                        bl3 = true;
                        break block10;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw Duration.b(illegalArgumentException);
                    }
                }
                bl3 = false;
            }
            return bl3;
        }
        try {
            bl2 = duration.l != duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public static boolean op_LessThan(Duration duration, Duration duration2) {
        boolean bl2;
        block6: {
            try {
                try {
                    if (duration != null && duration2 != null) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        try {
            bl2 = duration.l < duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public static boolean op_LessThanOrEqual(Duration duration, Duration duration2) {
        boolean bl2;
        block6: {
            try {
                try {
                    if (duration != null && duration2 != null) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        try {
            bl2 = duration.l <= duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public static boolean op_GreaterThan(Duration duration, Duration duration2) {
        boolean bl2;
        block6: {
            try {
                try {
                    if (duration != null && duration2 != null) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        try {
            bl2 = duration.l > duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public static boolean op_GreaterThanOrEqual(Duration duration, Duration duration2) {
        boolean bl2;
        block6: {
            try {
                try {
                    if (duration != null && duration2 != null) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Duration.b(illegalArgumentException);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Duration.b(illegalArgumentException);
            }
        }
        try {
            bl2 = duration.l >= duration2.l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return bl2;
    }

    public long getTicks() {
        return this.l;
    }

    public int getMilliseconds() {
        return (int)(this.l / 10000L % 1000L);
    }

    public int getSeconds() {
        return (int)(this.l / 10000000L % 60L);
    }

    public int getMinutes() {
        return (int)(this.l / 600000000L % 60L);
    }

    public int getHours() {
        return (int)(this.l / 36000000000L % 24L);
    }

    public int getDays() {
        return (int)(this.l / 864000000000L);
    }

    public long getTotalMilliseconds() {
        long l2 = (long)((double)this.l * 1.0E-4);
        try {
            if (l2 > 922337203685477L) {
                return 922337203685477L;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        try {
            if (l2 < -922337203685477L) {
                return -922337203685477L;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Duration.b(illegalArgumentException);
        }
        return l2;
    }

    public double getTotalSeconds() {
        return (double)this.l * 1.0E-7;
    }

    public double getTotalMinutes() {
        return (double)this.l * 1.6666666666666667E-9;
    }

    public double getTotalHours() {
        return (double)this.l * 2.7777777777777777E-11;
    }

    public double getTotalDays() {
        return (double)this.l * 1.1574074074074074E-12;
    }

    private static IllegalArgumentException b(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

