/*
 * Decompiled with CFR 0.152.
 */
package eu.miman.forge.plugin.util.helpers;

import eu.miman.forge.plugin.util.dto.MavenProjectId;
import eu.miman.forge.plugin.util.helpers.MavenPomHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.forge.project.ProjectModelException;

public class MavenPomHelperImpl
implements MavenPomHelper {
    @Override
    public Model openPOM(String filename) {
        try {
            Model result = new Model();
            MavenXpp3Reader reader = new MavenXpp3Reader();
            InputStream stream = this.getClass().getResourceAsStream(filename);
            if (stream.available() > 0) {
                result = reader.read(stream);
            }
            stream.close();
            File pomFile = new File(filename);
            result.setPomFile(pomFile);
            return result;
        }
        catch (IOException e) {
            throw new ProjectModelException("Could not open POM file: " + filename, (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ProjectModelException("Could not parse POM file: " + filename, (Throwable)e);
        }
    }

    @Override
    public boolean doesPomContainDependencies(List<Dependency> dependencies, Model pom) {
        List pomDeps = pom.getDependencies();
        for (Dependency dependency : dependencies) {
            boolean dependencyFound = false;
            for (Dependency pomDep : pomDeps) {
                if (!pomDep.getGroupId().equalsIgnoreCase(dependency.getGroupId()) || !pomDep.getArtifactId().equalsIgnoreCase(dependency.getArtifactId())) continue;
                if (!this.areDependenciesEqual(dependency, pomDep)) {
                    return false;
                }
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addOrUpdateParentProject(MavenProjectId prjId, Model pom) {
        if (pom.getParent() == null) {
            pom.setParent(new Parent());
        }
        pom.getParent().setGroupId(prjId.getGroupId());
        pom.getParent().setArtifactId(prjId.getArtifactId());
        pom.getParent().setVersion(prjId.getVersion());
        if (prjId.getRelativePath() != null) {
            pom.getParent().setRelativePath(prjId.getRelativePath() + "pom.xml");
        }
    }

    private boolean areDependenciesEqual(Dependency dependency, Dependency pomDep) {
        if (dependency.getExclusions().size() == 0 && pomDep.getExclusions().size() == 0) {
            return true;
        }
        List exclusions = dependency.getExclusions();
        for (Exclusion exclusion : exclusions) {
            List pomExclusions = pomDep.getExclusions();
            boolean found = false;
            for (Exclusion pomExclusion : pomExclusions) {
                if (!pomExclusion.getGroupId().equalsIgnoreCase(exclusion.getGroupId()) || !pomExclusion.getArtifactId().equalsIgnoreCase(exclusion.getArtifactId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

