/*
 * Decompiled with CFR 0.152.
 */
package eu.miman.forge.plugin.util;

import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.java.JavaResource;

public class VelocityUtil {
    private static final String UTF_8 = "UTF-8";

    public String capitalize(String orgString) {
        return StringUtils.capitalize((String)orgString);
    }

    public String uncapitalize(String orgString) {
        return StringUtils.uncapitalize((String)orgString);
    }

    public VelocityContext createVelocityContext(Map<String, Object> parameter) {
        if (parameter == null) {
            parameter = new HashMap<String, Object>();
        }
        VelocityContext velocityContext = new VelocityContext(parameter);
        return velocityContext;
    }

    public FileResource<?> createResourceAbsolute(String templateFilePath, VelocityContext velocityContext, String targetFilePath, Project project, VelocityEngine velocityEngine) {
        StringWriter stringWriter = new StringWriter();
        velocityEngine.mergeTemplate(templateFilePath, UTF_8, (Context)velocityContext, (Writer)stringWriter);
        ResourceFacet resources = (ResourceFacet)project.getFacet(ResourceFacet.class);
        FileResource createdResource = resources.createResource(stringWriter.toString().toCharArray(), targetFilePath);
        return createdResource;
    }

    public FileResource<?> createWebResourceAbsolute(String templateFilePath, VelocityContext velocityContext, String targetFilePath, Project project, VelocityEngine velocityEngine) {
        WebResourceFacet resources = (WebResourceFacet)project.getFacet(WebResourceFacet.class);
        StringWriter stringWriter = new StringWriter();
        velocityEngine.mergeTemplate(templateFilePath, UTF_8, (Context)velocityContext, (Writer)stringWriter);
        System.out.println("Storing web file in: " + targetFilePath);
        FileResource createdResource = resources.createWebResource(stringWriter.toString().toCharArray(), targetFilePath);
        return createdResource;
    }

    public JavaResource createJavaSource(String template, VelocityContext velocityContext, Project project, VelocityEngine velocityEngine) {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        StringWriter stringWriter = new StringWriter();
        velocityEngine.mergeTemplate(template, UTF_8, (Context)velocityContext, (Writer)stringWriter);
        JavaType serviceClass = (JavaType)JavaParser.parse(JavaType.class, (String)stringWriter.toString());
        try {
            JavaResource saveJavaSource = java.saveJavaSource((JavaSource)serviceClass);
            return saveJavaSource;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaResource createJavaTestSource(String template, VelocityContext velocityContext, Project project, VelocityEngine velocityEngine) {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        StringWriter stringWriter = new StringWriter();
        velocityEngine.mergeTemplate(template, UTF_8, (Context)velocityContext, (Writer)stringWriter);
        JavaType serviceClass = (JavaType)JavaParser.parse(JavaType.class, (String)stringWriter.toString());
        try {
            JavaResource saveJavaSource = java.saveTestJavaSource((JavaSource)serviceClass);
            return saveJavaSource;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaResource createJavaEnumSource(String template, VelocityContext velocityContext, Project project, VelocityEngine velocityEngine) {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        StringWriter stringWriter = new StringWriter();
        velocityEngine.mergeTemplate(template, UTF_8, (Context)velocityContext, (Writer)stringWriter);
        JavaEnum serviceClass = (JavaEnum)JavaParser.parse(JavaEnum.class, (String)stringWriter.toString());
        try {
            JavaResource saveJavaSource = java.saveEnumTypeSource(serviceClass);
            return saveJavaSource;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

