/*
 * Decompiled with CFR 0.152.
 */
package eu.miman.forge.plugin.util;

import eu.miman.forge.plugin.util.ForgeProjectUtil;
import eu.miman.forge.plugin.util.dto.MavenProjectId;
import eu.miman.forge.plugin.util.dto.ProjectWithPath;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;

public class NazgulPrjUtil {
    ForgeProjectUtil forgeProjectUtil = new ForgeProjectUtil();

    public MavenProjectId getParentProjectId(Project project, ProjectFactory prjFactory) {
        MavenProjectId reply = new MavenProjectId();
        ProjectWithPath parentPrj = this.findParentProject(project, prjFactory);
        if (parentPrj == null) {
            return null;
        }
        MavenCoreFacet maprentPrjMvnFacet = (MavenCoreFacet)parentPrj.getProject().getFacet(MavenCoreFacet.class);
        Model parentPom = maprentPrjMvnFacet.getPOM();
        reply.setGroupId(parentPom.getGroupId());
        reply.setArtifactId(parentPom.getArtifactId());
        reply.setVersion(parentPom.getVersion());
        reply.setRelativePath(parentPrj.getPathToParent());
        return reply;
    }

    public Project findRootProject(Project project, ProjectFactory prjFactory) {
        DirectoryResource rootDir = this.findRootDirectory(project, prjFactory);
        if (rootDir == null) {
            return null;
        }
        Project prj = prjFactory.createProject(rootDir, new Class[]{MavenCoreFacet.class});
        return prj;
    }

    public ProjectWithPath findParentProject(Project project, ProjectFactory prjFactory) {
        DirectoryResource rootDir = this.findRootDirectory(project, prjFactory);
        DirectoryResource dirForThisPrj = project.getProjectRoot();
        if (rootDir == null) {
            return null;
        }
        for (Resource child : rootDir.listResources()) {
            Resource parentDir;
            if (!"poms".equals(child.getName()) || !DirectoryResource.class.isInstance(child) || !DirectoryResource.class.isInstance(parentDir = ((DirectoryResource)child).getChild(child.getParent().getName() + "-parent"))) continue;
            String pathToParent = this.calculatePathToDir(dirForThisPrj.getFullyQualifiedName(), parentDir.getFullyQualifiedName());
            ProjectWithPath reply = new ProjectWithPath(prjFactory.createProject((DirectoryResource)parentDir, new Class[]{MavenCoreFacet.class}), pathToParent);
            return reply;
        }
        return null;
    }

    public String calculatePathToDir(String source, String target) {
        int j;
        int nrOfDirsUpToSame;
        int i;
        StringBuffer reply = new StringBuffer();
        ArrayList<String> replyPath = new ArrayList<String>();
        source = source.replace("\\", "/");
        target = target.replace("\\", "/");
        String[] sourceParts = source.split(Pattern.quote("/"));
        String[] targetParts = target.split(Pattern.quote("/"));
        int noOfSameDirs = 0;
        if (target.equalsIgnoreCase(source)) {
            return "." + File.separator;
        }
        if (target.startsWith(source)) {
            noOfSameDirs = sourceParts.length;
        } else if (source.startsWith(target)) {
            for (i = 0; targetParts.length > i && sourceParts.length >= i && targetParts[i].equals(sourceParts[i]); ++i) {
            }
            nrOfDirsUpToSame = sourceParts.length - i;
            for (j = 0; j < nrOfDirsUpToSame; ++j) {
                replyPath.add("..");
            }
            noOfSameDirs = i;
        } else {
            for (i = 0; sourceParts.length >= i && targetParts.length >= i && sourceParts[i].equals(targetParts[i]); ++i) {
            }
            nrOfDirsUpToSame = sourceParts.length - i;
            for (j = 0; j < nrOfDirsUpToSame; ++j) {
                replyPath.add("..");
            }
            noOfSameDirs = i;
        }
        for (i = noOfSameDirs; i < targetParts.length; ++i) {
            replyPath.add(targetParts[i]);
        }
        for (String dir : replyPath) {
            if (dir.length() <= 0) continue;
            reply.append(dir + File.separator);
        }
        return reply.toString();
    }

    public Project findProjectWithArtifactId(Project project, String artifactId, ProjectFactory prjFactory) {
        DirectoryResource rootDir = this.findRootDirectory(project, prjFactory);
        Project prj = NazgulPrjUtil.findSubProjectWithArtifactId(artifactId, prjFactory, rootDir);
        return prj;
    }

    private static Project findSubProjectWithArtifactId(String artifactId, ProjectFactory prjFactory, DirectoryResource rootDir) {
        for (Resource child : rootDir.listResources()) {
            if (!DirectoryResource.class.isInstance(child) || !prjFactory.containsProject((DirectoryResource)child)) continue;
            Project prj = prjFactory.createProject((DirectoryResource)child, new Class[]{MavenCoreFacet.class});
            MavenCoreFacet mvnFacet = (MavenCoreFacet)prj.getFacet(MavenCoreFacet.class);
            Model pom = mvnFacet.getPOM();
            if (artifactId.compareToIgnoreCase(pom.getArtifactId()) == 0) {
                return prj;
            }
            Project p = NazgulPrjUtil.findSubProjectWithArtifactId(artifactId, prjFactory, (DirectoryResource)child);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private DirectoryResource findRootDirectory(Project project, ProjectFactory prjFactory) {
        for (DirectoryResource currentDir = project.getProjectRoot(); currentDir != null; currentDir = (DirectoryResource)currentDir.getParent()) {
            DirectoryResource pomsDir = this.forgeProjectUtil.findSubFolderWithName("poms", prjFactory, currentDir);
            if (pomsDir == null) continue;
            return currentDir;
        }
        return null;
    }
}

