/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.view;

import eu.miltema.slimweb.view.TemplateResolver;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class TestTemplateResolver {
    private Map<String, String> values = Stream.of("name:John", "job:driver", "home:Europe", "qualified.label:world").collect(Collectors.toMap(s -> s.split(":")[0], s -> s.split(":")[1]));

    @Test
    public void testReplaceStartMiddleEnd() {
        Assert.assertEquals((Object)"John is driver from Europe", (Object)new TemplateResolver().replace("{-name-} is {-job-} from {-home-}", this.values, null));
    }

    @Test
    public void testReplaceMiddle() {
        Assert.assertEquals((Object)"zzz driver yyy", (Object)new TemplateResolver().replace("zzz {-job-} yyy", this.values, null));
    }

    @Test
    public void testMissingReplacement() {
        Assert.assertEquals((Object)"zzz !!!xyz!!! yyy", (Object)new TemplateResolver().replace("zzz {-xyz-} yyy", this.values, null));
    }

    @Test
    public void testQualifiedKey() {
        Assert.assertEquals((Object)"zzz world !!!qualified.notfound!!! yyy", (Object)new TemplateResolver().replace("zzz {-.label-} {-.notfound-} yyy", this.values, "qualified"));
    }

    @Test
    public void testCustomReplacers() {
        TemplateResolver tr = new TemplateResolver().customReplacer("a:", suffix -> "#" + suffix + "#").customReplacer("b:", suffix -> "_" + suffix + "_");
        Assert.assertEquals((Object)"zzz driver, #mm#, _rr_, !!!c:tt!!! yyy", (Object)tr.replace("zzz {-job-}, {-a:mm-}, {-b:rr-}, {-c:tt-} yyy", this.values, null));
    }
}

