/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimorm.test;

import eu.miltema.slimorm.test.AbstractDatabaseTest;
import eu.miltema.slimorm.test.SlimTestEntity;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWrite
extends AbstractDatabaseTest {
    @BeforeClass
    public static void setupClass() throws Exception {
        TestWrite.initDatabase();
    }

    @Test
    public void testInsertReturnsKey() throws Exception {
        Assert.assertNotNull((Object)((SlimTestEntity)TestWrite.db.insert((Object)new SlimTestEntity((String)"John", null))).id);
    }

    @Test
    public void testInsertedFields() throws Exception {
        SlimTestEntity e = (SlimTestEntity)db.insert((Object)new SlimTestEntity("John", null));
        e = (SlimTestEntity)db.getById(SlimTestEntity.class, (Object)e.id);
        Assert.assertEquals((Object)"John", (Object)e.name);
        Assert.assertNull((Object)e.count);
    }

    @Test
    public void testUpdate() throws Exception {
        SlimTestEntity e = (SlimTestEntity)db.insert((Object)new SlimTestEntity("John", null));
        e.name = "Peter";
        e.count = 4;
        db.update((Object)e);
        e = (SlimTestEntity)db.getById(SlimTestEntity.class, (Object)e.id);
        Assert.assertEquals((Object)"Peter", (Object)e.name);
        Assert.assertEquals((Object)4, (Object)e.count);
        e.count = null;
        db.update((Object)e);
        e = (SlimTestEntity)db.getById(SlimTestEntity.class, (Object)e.id);
        Assert.assertNull((Object)e.count);
    }

    @Test
    public void testBulk() throws Exception {
        List entities = db.bulkInsert(Stream.of(new SlimTestEntity("Mary", 3), new SlimTestEntity("Ann", null)).collect(Collectors.toList()));
        Assert.assertEquals((Object)"Mary", (Object)((SlimTestEntity)entities.get((int)0)).name);
        Assert.assertEquals((Object)"Ann", (Object)((SlimTestEntity)entities.get((int)1)).name);
        Assert.assertNotNull((Object)((SlimTestEntity)entities.get((int)0)).id);
        Assert.assertNotNull((Object)((SlimTestEntity)entities.get((int)1)).id);
        SlimTestEntity e1 = (SlimTestEntity)db.getById(SlimTestEntity.class, (Object)((SlimTestEntity)entities.get((int)0)).id);
        Assert.assertEquals((Object)"Mary", (Object)e1.name);
        Assert.assertEquals((Object)3, (Object)e1.count);
        SlimTestEntity e2 = (SlimTestEntity)db.getById(SlimTestEntity.class, (Object)((SlimTestEntity)entities.get((int)1)).id);
        Assert.assertEquals((Object)"Ann", (Object)e2.name);
        Assert.assertNull((Object)e2.count);
    }

    @Test
    public void testLargeBulkInsert() throws Exception {
        List list = IntStream.rangeClosed(1, 10000).mapToObj(i -> new SlimTestEntity("nimi" + i, i)).collect(Collectors.toList());
        list = db.bulkInsert(list);
        Assert.assertEquals((long)10000L, (long)list.stream().map(e -> e.id).collect(Collectors.toSet()).size());
    }

    @Test
    public void testDelete() throws Exception {
        Integer id = ((SlimTestEntity)TestWrite.db.insert((Object)new SlimTestEntity((String)"John", null))).id;
        db.delete(SlimTestEntity.class, (Object)id);
        Assert.assertNull((Object)db.getById(SlimTestEntity.class, (Object)id));
    }

    @Test
    public void testDeleteWhere() throws Exception {
        this.deleteAll();
        db.bulkInsert(IntStream.rangeClosed(1, 10).mapToObj(i -> new SlimTestEntity("Mary", i)).collect(Collectors.toList()));
        Assert.assertEquals((long)4L, (long)db.deleteWhere(SlimTestEntity.class, "count>=?", new Object[]{7}));
    }

    @Test
    public void testSuccessfulTransaction() throws Exception {
        Integer id = (Integer)TestWrite.db.transaction((db, connection) -> {
            SlimTestEntity e = (SlimTestEntity)db.insert((Object)new SlimTestEntity("John", null));
            e.name = "Peter";
            e.count = 4;
            db.update((Object)e);
            return e.id;
        });
        SlimTestEntity e = (SlimTestEntity)TestWrite.db.getById(SlimTestEntity.class, (Object)id);
        Assert.assertEquals((long)4L, (long)e.count.intValue());
    }

    @Test(expected=TestWriteException.class)
    public void testFailedTransaction() throws Exception {
        this.deleteAll();
        try {
            TestWrite.db.transaction((db, connection) -> {
                SlimTestEntity e = (SlimTestEntity)db.insert((Object)new SlimTestEntity("John", 2));
                e.name = "Peter";
                e.count = null;
                db.update((Object)e);
                throw new TestWriteException();
            });
        }
        catch (TestWriteException x) {
            Assert.assertEquals((long)0L, (long)TestWrite.db.listAll(SlimTestEntity.class).size());
            throw x;
        }
    }

    private class TestWriteException
    extends Exception {
        private TestWriteException() {
        }
    }
}

