/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimorm.test;

import eu.miltema.slimorm.test.AbstractDatabaseTest;
import eu.miltema.slimorm.test.Entity2;
import eu.miltema.slimorm.test.TestStruct;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTypes
extends AbstractDatabaseTest {
    @BeforeClass
    public static void setupClass() throws Exception {
        TestTypes.initDatabase();
    }

    @Test
    public void testString() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fString = "abc";
        }));
        Assert.assertEquals((Object)"abc", (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fString);
    }

    @Test
    public void testByte() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fByte1 = (byte)23;
        }));
        Assert.assertEquals((long)23L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fByte1);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fByte2 = 34;
        }));
        Assert.assertEquals((long)34L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fByte2.byteValue());
    }

    @Test
    public void testShort() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fShort1 = (short)23;
        }));
        Assert.assertEquals((long)23L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fShort1);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fShort2 = 34;
        }));
        Assert.assertEquals((long)34L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fShort2.shortValue());
    }

    @Test
    public void testInt() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fInt1 = 23;
        }));
        Assert.assertEquals((long)23L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fInt1);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fInt2 = 34;
        }));
        Assert.assertEquals((long)34L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fInt2.intValue());
    }

    @Test
    public void testLong() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fLong1 = 23L;
        }));
        Assert.assertEquals((long)23L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fLong1);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fLong2 = 34L;
        }));
        Assert.assertEquals((long)34L, (long)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fLong2);
    }

    @Test
    public void testFloat() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fFloat1 = 23.78f;
        }));
        Assert.assertEquals((float)23.78f, (float)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fFloat1, (float)1.0E-4f);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fFloat2 = Float.valueOf(34.11f);
        }));
        Assert.assertEquals((float)34.11f, (float)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fFloat2.floatValue(), (float)1.0E-4f);
    }

    @Test
    public void testDouble() throws Exception {
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fDouble1 = 23.28;
        }));
        Assert.assertEquals((double)23.28, (double)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fDouble1, (double)1.0E-4);
        e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fDouble2 = 34.11;
        }));
        Assert.assertEquals((double)34.11, (double)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fDouble2, (double)1.0E-4);
    }

    @Test
    public void testBigDecimal() throws Exception {
        BigDecimal b = new BigDecimal("1234567890123456789012345678901234567890.55");
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fBigDecimal = b;
        }));
        Assert.assertEquals((Object)b, (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fBigDecimal);
    }

    @Test
    public void testByteArray() throws Exception {
        byte[] ba = new byte[]{4, 7, 9, -5};
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fByteArray = ba;
        }));
        Assert.assertArrayEquals((byte[])ba, (byte[])((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fByteArray);
    }

    @Test
    public void testTimestampWithoutTimezone() throws Exception {
        Instant i = Instant.parse("2007-12-03T10:15:30.00Z");
        Timestamp ts = Timestamp.from(i);
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fTimestamp = ts;
        }));
        Assert.assertEquals((Object)ts, (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fTimestamp);
    }

    @Test
    public void testInstant() throws Exception {
        Instant i = Instant.parse("2007-12-03T10:15:30.00Z");
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fInstant = i;
        }));
        Assert.assertEquals((Object)i, (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fInstant);
    }

    @Test
    public void testZonedDateTime() throws Exception {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.parse("2007-12-03T10:15:30.00Z"), ZoneId.of("Asia/Tokyo"));
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fZonedDateTime = zdt;
        }));
        Assert.assertEquals((Object)zdt.toInstant(), (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fZonedDateTime.toInstant());
    }

    @Test
    public void testLocalDate() throws Exception {
        LocalDate ld = LocalDate.parse("2012-12-23");
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fLocalDate = ld;
        }));
        Assert.assertEquals((Object)ld, (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fLocalDate);
    }

    @Test
    public void testLocalDateTime() throws Exception {
        LocalDateTime ldt = LocalDateTime.parse("2007-12-03T10:15:30.20");
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fLocalDateTime = ldt;
        }));
        Assert.assertEquals((Object)ldt, (Object)((Entity2)TestTypes.db.getById(Entity2.class, (Object)Integer.valueOf((int)e.id))).fLocalDateTime);
    }

    @Test
    public void testJSon() throws Exception {
        TestStruct s = new TestStruct();
        s.attr1 = "abc";
        s.attr2 = 4.76;
        s.attr3 = true;
        Entity2 e = (Entity2)db.insert((Object)new Entity2(x -> {
            x.fJson2 = new String[]{"abc", "def"};
        }, x -> {
            x.fJson1 = s;
        }));
        e = (Entity2)db.getById(Entity2.class, (Object)e.id);
        Assert.assertEquals((double)4.76, (double)e.fJson1.attr2, (double)1.0E-4);
        Assert.assertEquals((Object)"def", (Object)e.fJson2[1]);
    }
}

