/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimorm.test;

import eu.miltema.slimorm.test.AbstractDatabaseTest;
import eu.miltema.slimorm.test.SlimTestEntity;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRead
extends AbstractDatabaseTest {
    @BeforeClass
    public static void setupClass() throws Exception {
        TestRead.initDatabase();
    }

    @Test
    public void getById() throws Exception {
        SlimTestEntity e = new SlimTestEntity();
        e.name = "John";
        db.insert((Object)e);
        Assert.assertNotNull((Object)db.getById(SlimTestEntity.class, (Object)e.id));
    }

    @Test
    public void testListAll() throws Exception {
        this.deleteAll();
        SlimTestEntity e1 = new SlimTestEntity();
        e1.name = "Mary";
        SlimTestEntity e2 = new SlimTestEntity();
        e2.name = "Ann";
        db.bulkInsert(Stream.of(e1, e2).collect(Collectors.toList()));
        List list = db.listAll(SlimTestEntity.class);
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testListWhere() throws Exception {
        this.deleteAll();
        db.bulkInsert(IntStream.rangeClosed(1, 10).mapToObj(i -> {
            SlimTestEntity e = new SlimTestEntity();
            e.name = "Mary";
            e.count = i;
            return e;
        }).collect(Collectors.toList()));
        List list = db.where("count>=? AND count<=?", new Object[]{3, 7}).list(SlimTestEntity.class);
        Assert.assertEquals((long)5L, (long)list.size());
    }
}

