/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimorm.test;

import eu.miltema.slimorm.test.AbstractDatabaseTest;
import eu.miltema.slimorm.test.SlimTestEntityWithoutId;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEntityWithoutId
extends AbstractDatabaseTest {
    @BeforeClass
    public static void setupClass() throws Exception {
        TestEntityWithoutId.initDatabase();
    }

    @Test
    public void testInsert() throws Exception {
        this.deleteAll();
        SlimTestEntityWithoutId e = new SlimTestEntityWithoutId();
        e.firstName = "John";
        e.count = 7;
        db.insert((Object)e);
        List list = db.listAll(SlimTestEntityWithoutId.class);
        Assert.assertEquals((long)1L, (long)list.size());
        e = (SlimTestEntityWithoutId)list.get(0);
        Assert.assertEquals((Object)"John", (Object)e.firstName);
        Assert.assertEquals((long)7L, (long)e.count.intValue());
    }

    @Test
    public void testBulkInsert() throws Exception {
        this.deleteAll();
        db.bulkInsert(Stream.of(new SlimTestEntityWithoutId("Mary", 3), new SlimTestEntityWithoutId("Ann", null)).collect(Collectors.toList()));
        Assert.assertEquals((long)2L, (long)db.listAll(SlimTestEntityWithoutId.class).size());
    }

    @Test
    public void testWhere() throws Exception {
        this.deleteAll();
        db.bulkInsert(Stream.of(new SlimTestEntityWithoutId("Mary", 3), new SlimTestEntityWithoutId("Marco", 1), new SlimTestEntityWithoutId("Ann", 5)).collect(Collectors.toList()));
        Assert.assertEquals((long)2L, (long)db.where("name LIKE ?", new Object[]{"Ma%"}).list(SlimTestEntityWithoutId.class).size());
    }
}

