/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.spring.boot.wro4j;

import java.util.Optional;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import ro.isdc.wro.cache.CacheStrategy;

class SpringCacheStrategy<K, V>
implements CacheStrategy<K, V> {
    private final CacheManager cacheManager;
    private final String cacheName;

    SpringCacheStrategy(CacheManager cacheManager, String cacheName) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }

    public void put(K key, V value) {
        this.cacheManager.getCache(this.cacheName).put(key, value);
    }

    public V get(K key) {
        return Optional.of(this.cacheManager.getCache(this.cacheName)).map(c -> c.get(key)).map(Cache.ValueWrapper::get).orElse(null);
    }

    public void clear() {
        this.cacheManager.getCache(this.cacheName).clear();
    }

    public void destroy() {
        this.clear();
    }
}

