/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.spring.boot.wro4j;

import java.util.function.Function;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import ro.isdc.wro.cache.CacheStrategy;

class SpringCacheStrategy<K, V>
implements CacheStrategy<K, V> {
    private final CacheManager cacheManager;
    private final String cacheName;

    SpringCacheStrategy(CacheManager cacheManager, String cacheName) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }

    public void put(K key, V value) {
        this.doWithCache(cache -> {
            cache.put(key, value);
            return null;
        });
    }

    public V get(K key) {
        Object result = this.doWithCache(cache -> {
            Cache.ValueWrapper w = cache.get(key);
            return w == null ? null : w.get();
        });
        return (V)result;
    }

    public void clear() {
        this.doWithCache(cache -> {
            cache.clear();
            return null;
        });
    }

    private Object doWithCache(Function<Cache, Object> consumer) {
        Cache cache = this.cacheManager.getCache(this.cacheName);
        if (cache == null) {
            return null;
        }
        return consumer.apply(cache);
    }

    public void destroy() {
        this.clear();
    }
}

