/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.spring.boot.wro4j.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class RemoveSourceMapsProcessor
implements ResourcePreProcessor {
    public static final Pattern SOURCE_MAP_PATTERN = Pattern.compile("^/(?:\\*|/)?(?:#|@) sourceMappingURL=.+(?:\\s+\\*/)?$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        BufferedReader _reader = new BufferedReader(reader);
        BufferedWriter _writer = new BufferedWriter(writer);
        try {
            String line;
            while ((line = _reader.readLine()) != null) {
                if (SOURCE_MAP_PATTERN.matcher(line).matches()) continue;
                _writer.write(line);
                _writer.newLine();
            }
        }
        finally {
            _reader.close();
            _writer.flush();
            _writer.close();
        }
    }
}

