/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.spring.boot.wro4j;

import ac.simons.spring.boot.wro4j.SpringCacheStrategy;
import ac.simons.spring.boot.wro4j.Wro4jProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.http.ConfigurableWroFilter;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.DefaultProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;

@Configuration
@ConditionalOnClass(value={WroFilter.class})
@ConditionalOnMissingBean(value={WroFilter.class})
@EnableConfigurationProperties(value={Wro4jProperties.class})
public class Wro4jAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Wro4jAutoConfiguration.class.getName());

    @Bean
    @ConditionalOnMissingBean(value={WroManagerFactory.class, WroModelFactory.class})
    WroModelFactory wroModelFactory(final Wro4jProperties wro4jProperties) {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() {
                return ((Object)((Object)this)).getClass().getResourceAsStream(wro4jProperties.getModel());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean(value={WroManagerFactory.class, ProcessorsFactory.class})
    ProcessorsFactory processorsFactory(Wro4jProperties wro4jProperties) {
        void var4_10;
        ArrayList<ResourcePreProcessor> preProcessors = new ArrayList<ResourcePreProcessor>();
        if (wro4jProperties.getPreProcessors() != null) {
            for (Class<? extends ResourcePreProcessor> clazz : wro4jProperties.getPreProcessors()) {
                preProcessors.add((ResourcePreProcessor)new BeanWrapperImpl(clazz).getWrappedInstance());
            }
        }
        ArrayList<ResourcePostProcessor> postProcessors = new ArrayList<ResourcePostProcessor>();
        if (wro4jProperties.getPostProcessors() != null) {
            for (Class<? extends ResourcePostProcessor> clazz : wro4jProperties.getPostProcessors()) {
                postProcessors.add((ResourcePostProcessor)new BeanWrapperImpl(clazz).getWrappedInstance());
            }
        }
        if (wro4jProperties.getManagerFactory() != null) {
            Properties properties = new Properties();
            if (wro4jProperties.getManagerFactory().getPreProcessors() != null) {
                properties.setProperty("preProcessors", wro4jProperties.getManagerFactory().getPreProcessors());
            }
            if (wro4jProperties.getManagerFactory().getPostProcessors() != null) {
                properties.setProperty("postProcessors", wro4jProperties.getManagerFactory().getPostProcessors());
            }
            ConfigurableProcessorsFactory configurableProcessorsFactory = new ConfigurableProcessorsFactory();
            configurableProcessorsFactory.setProperties(properties);
        } else if (preProcessors.isEmpty() && postProcessors.isEmpty()) {
            DefaultProcessorsFactory defaultProcessorsFactory = new DefaultProcessorsFactory();
        } else {
            SimpleProcessorsFactory simpleProcessorsFactory = new SimpleProcessorsFactory();
            simpleProcessorsFactory.setResourcePreProcessors(preProcessors);
            simpleProcessorsFactory.setResourcePostProcessors(postProcessors);
        }
        LOGGER.debug("Using ProcessorsFactory of type '{}'", (Object)var4_10.getClass().getName());
        return var4_10;
    }

    @Bean
    @ConditionalOnBean(value={CacheManager.class})
    @ConditionalOnProperty(value={"wro4j.cacheName"})
    @ConditionalOnMissingBean(value={CacheStrategy.class})
    <K, V> CacheStrategy<K, V> defaultCacheStrategy(CacheManager cacheManager, Wro4jProperties wro4jProperties) {
        LOGGER.debug("Creating cache strategy 'SpringCacheStrategy'");
        return new SpringCacheStrategy(cacheManager, wro4jProperties.getCacheName());
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheStrategy.class})
    <K, V> CacheStrategy<K, V> springCacheStrategy(CacheManager cacheManager, Wro4jProperties wro4jProperties) {
        LOGGER.debug("Creating cache strategy 'LruMemoryCacheStrategy'");
        return new LruMemoryCacheStrategy();
    }

    @Bean
    @ConditionalOnMissingBean(value={WroManagerFactory.class})
    WroManagerFactory wroManagerFactory(WroModelFactory wroModelFactory, ProcessorsFactory processorsFactory, CacheStrategy cacheStrategy) {
        return new BaseWroManagerFactory().setModelFactory(wroModelFactory).setProcessorsFactory(processorsFactory).setCacheStrategy(cacheStrategy);
    }

    @Bean
    ConfigurableWroFilter wroFilter(WroManagerFactory wroManagerFactory, Wro4jProperties wro4jProperties) {
        ConfigurableWroFilter wroFilter = new ConfigurableWroFilter();
        wroFilter.setProperties(this.wroFilterProperties(wro4jProperties));
        wroFilter.setWroManagerFactory(wroManagerFactory);
        return wroFilter;
    }

    Properties wroFilterProperties(Wro4jProperties wro4jProperties) {
        Properties properties = new Properties();
        properties.setProperty(ConfigConstants.debug.name(), String.valueOf(wro4jProperties.isDebug()));
        properties.setProperty(ConfigConstants.minimizeEnabled.name(), String.valueOf(wro4jProperties.isMinimizeEnabled()));
        properties.setProperty(ConfigConstants.gzipResources.name(), String.valueOf(wro4jProperties.isGzipResources()));
        if (wro4jProperties.getResourceWatcherUpdatePeriod() != null) {
            properties.setProperty(ConfigConstants.resourceWatcherUpdatePeriod.name(), String.valueOf(wro4jProperties.getResourceWatcherUpdatePeriod()));
        }
        properties.setProperty(ConfigConstants.resourceWatcherAsync.name(), String.valueOf(wro4jProperties.isResourceWatcherAsync()));
        if (wro4jProperties.getCacheUpdatePeriod() != null) {
            properties.setProperty(ConfigConstants.cacheUpdatePeriod.name(), String.valueOf(wro4jProperties.getCacheUpdatePeriod()));
        }
        if (wro4jProperties.getModelUpdatePeriod() != null) {
            properties.setProperty(ConfigConstants.modelUpdatePeriod.name(), String.valueOf(wro4jProperties.getModelUpdatePeriod()));
        }
        if (wro4jProperties.getHeader() != null && !wro4jProperties.getHeader().trim().isEmpty()) {
            properties.setProperty(ConfigConstants.header.name(), wro4jProperties.getHeader());
        }
        properties.setProperty(ConfigConstants.parallelPreprocessing.name(), String.valueOf(wro4jProperties.isParallelPreprocessing()));
        if (wro4jProperties.getConnectionTimeout() != null) {
            properties.setProperty(ConfigConstants.connectionTimeout.name(), String.valueOf(wro4jProperties.getConnectionTimeout()));
        }
        if (wro4jProperties.getEncoding() != null && !wro4jProperties.getEncoding().trim().isEmpty()) {
            properties.setProperty(ConfigConstants.encoding.name(), wro4jProperties.getEncoding());
        }
        properties.setProperty(ConfigConstants.ignoreMissingResources.name(), String.valueOf(wro4jProperties.isIgnoreMissingResources()));
        properties.setProperty(ConfigConstants.ignoreEmptyGroup.name(), String.valueOf(wro4jProperties.isIgnoreEmptyGroup()));
        properties.setProperty(ConfigConstants.ignoreFailingProcessor.name(), String.valueOf(wro4jProperties.isIgnoreFailingProcessor()));
        properties.setProperty(ConfigConstants.cacheGzippedContent.name(), String.valueOf(wro4jProperties.isCacheGzippedContent()));
        properties.setProperty(ConfigConstants.jmxEnabled.name(), String.valueOf(wro4jProperties.isJmxEnabled()));
        if (wro4jProperties.getMbeanName() != null && !wro4jProperties.getMbeanName().trim().isEmpty()) {
            properties.setProperty(ConfigConstants.mbeanName.name(), wro4jProperties.getMbeanName());
        }
        return properties;
    }

    @Bean
    FilterRegistrationBean wro4jFilterRegistration(ConfigurableWroFilter wroFilter, Wro4jProperties wro4jProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)wroFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{wro4jProperties.getFilterUrl() + "/*"});
        return filterRegistrationBean;
    }
}

