/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.DefaultOembedResponseRenderer;
import ac.simons.oembed.DefaultRequestProvider;
import ac.simons.oembed.OembedException;
import ac.simons.oembed.OembedResponse;
import ac.simons.oembed.OembedResponseRenderer;
import ac.simons.oembed.RequestProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class OembedEndpoint {
    private String name;
    private String endpoint;
    private OembedResponse.Format format = OembedResponse.Format.json;
    private Integer maxWidth;
    private Integer maxHeight;
    private List<String> urlSchemes;
    private Class<? extends RequestProvider> requestProviderClass = DefaultRequestProvider.class;
    private Map<String, String> requestProviderProperties;
    private Class<? extends OembedResponseRenderer> responseRendererClass = DefaultOembedResponseRenderer.class;
    private Map<String, String> responseRendererProperties;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public OembedResponse.Format getFormat() {
        return this.format;
    }

    public void setFormat(OembedResponse.Format format) {
        this.format = format;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public List<String> getUrlSchemes() {
        return this.urlSchemes;
    }

    public void setUrlSchemes(List<String> urlSchemes) {
        this.urlSchemes = urlSchemes;
    }

    public Class<? extends RequestProvider> getRequestProviderClass() {
        return this.requestProviderClass;
    }

    public void setRequestProviderClass(Class<? extends RequestProvider> requestProviderClass) {
        this.requestProviderClass = requestProviderClass;
    }

    public Map<String, String> getRequestProviderProperties() {
        return this.requestProviderProperties;
    }

    public void setRequestProviderProperties(Map<String, String> requestProviderProperties) {
        this.requestProviderProperties = requestProviderProperties;
    }

    public Class<? extends OembedResponseRenderer> getResponseRendererClass() {
        return this.responseRendererClass;
    }

    public void setResponseRendererClass(Class<? extends OembedResponseRenderer> responseRendererClass) {
        this.responseRendererClass = responseRendererClass;
    }

    public Map<String, String> getResponseRendererProperties() {
        return this.responseRendererProperties;
    }

    public void setResponseRendererProperties(Map<String, String> responseRendererProperties) {
        this.responseRendererProperties = responseRendererProperties;
    }

    public URI toApiUrl(String url) {
        String uri;
        ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
        if (this.getEndpoint().toLowerCase().contains("%{format}")) {
            uri = this.getEndpoint().replaceAll(Pattern.quote("%{format}"), this.getFormat().toString());
        } else {
            uri = this.getEndpoint();
            query.add(new BasicNameValuePair("format", this.getFormat().toString()));
        }
        query.add(new BasicNameValuePair("url", url));
        if (this.getMaxWidth() != null) {
            query.add(new BasicNameValuePair("maxwidth", this.getMaxWidth().toString()));
        }
        if (this.getMaxHeight() != null) {
            query.add(new BasicNameValuePair("maxheight", this.getMaxHeight().toString()));
        }
        try {
            return new URIBuilder(uri).addParameters(query).build();
        }
        catch (URISyntaxException ex) {
            throw new OembedException(ex);
        }
    }
}

