/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.OembedResponse;
import ac.simons.oembed.OembedResponseRenderer;
import org.jsoup.nodes.Element;

class DefaultOembedResponseRenderer
implements OembedResponseRenderer {
    DefaultOembedResponseRenderer() {
    }

    @Override
    public String render(OembedResponse response, Element originalAnchor) {
        String rv = null;
        if (response.getType().equalsIgnoreCase("photo")) {
            String _title = response.getTitle() == null ? "" : response.getTitle();
            rv = String.format("<img src=\"%s\" style=\"width:%dpx; height:%dpx;\" alt=\"%s\" title=\"%s\"/>", response.getUrl(), response.getWidth(), response.getHeight(), _title, _title);
        } else if (response.getType().equalsIgnoreCase("video")) {
            rv = response.getHtml();
        } else if (response.getType().equalsIgnoreCase("link")) {
            String originalUrl = originalAnchor.absUrl("href");
            String _title = response.getTitle() == null ? originalUrl : response.getTitle();
            String _url = response.getUrl() == null ? originalUrl : response.getUrl();
            rv = String.format("<a href=\"%s\">%s</a>", _url, _title);
        } else if (response.getType().equalsIgnoreCase("rich")) {
            rv = response.getHtml();
        }
        return rv;
    }
}

