/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.OembedException;
import ac.simons.oembed.OembedParser;
import ac.simons.oembed.OembedResponse;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.InputStream;
import java.io.OutputStream;

public class OembedJsonParser
implements OembedParser {
    private final ObjectMapper objectMapper;

    public OembedJsonParser() {
        this.objectMapper = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public OembedJsonParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public OembedResponse unmarshal(InputStream httpResponse) throws OembedException {
        try {
            return (OembedResponse)this.objectMapper.readValue(httpResponse, OembedResponse.class);
        }
        catch (Exception e) {
            throw new OembedException(e);
        }
    }

    @Override
    public String marshal(OembedResponse oembedResponse) throws OembedException {
        try {
            return this.objectMapper.writeValueAsString((Object)oembedResponse);
        }
        catch (Exception e) {
            throw new OembedException(e);
        }
    }

    @Override
    public void marshal(OembedResponse oembedResponse, OutputStream outputStream) throws OembedException {
        try {
            this.objectMapper.writeValue(outputStream, (Object)oembedResponse);
        }
        catch (Exception e) {
            throw new OembedException(e);
        }
    }
}

