/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.AutodiscoveredOembedProvider;
import ac.simons.oembed.OembedException;
import ac.simons.oembed.OembedJsonParser;
import ac.simons.oembed.OembedParser;
import ac.simons.oembed.OembedProvider;
import ac.simons.oembed.OembedResponse;
import ac.simons.oembed.OembedResponseHandler;
import ac.simons.oembed.OembedXmlParser;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oembed {
    private final Long MIN_VALID_CACHE_AGE = new Long(Integer.MIN_VALUE);
    private final Long MAX_VALID_CACHE_AGE = new Long(Integer.MAX_VALUE);
    private final Logger logger = LoggerFactory.getLogger(Oembed.class);
    private final HttpClient httpClient;
    private Map<String, OembedProvider> provider = new HashMap<String, OembedProvider>();
    private Map<String, OembedResponseHandler> handler = new HashMap<String, OembedResponseHandler>();
    private Map<String, OembedParser> parser;
    private CacheManager cacheManager;
    private int defaultCacheAge = 3600;
    private boolean autodiscovery = false;
    private Long ignoreFailedUrlsForSeconds = new Long(86400L);
    private String baseUri = "";
    private String cacheName = Oembed.class.getName();
    private String userAgent;
    private String consumer;

    public Oembed(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.parser = new HashMap<String, OembedParser>();
        this.parser.put("json", new OembedJsonParser());
        this.parser.put("xml", new OembedXmlParser());
        Properties version = new Properties();
        try {
            version.load(Oembed.class.getResourceAsStream("/ac/simons/oembed/version.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userAgent = String.format("Java/%s java-oembed/%s", System.getProperty("java.version"), version.getProperty("ac.simons.oembed.version"));
        this.logger.info(String.format("Oembed (%s) ready...", this.userAgent));
    }

    public Map<String, OembedProvider> getProvider() {
        return this.provider;
    }

    public void setProvider(Map<String, OembedProvider> provider) {
        this.provider = provider;
    }

    public OembedParser getParser(String format) {
        return this.parser.get(format);
    }

    public OembedParser setParser(String format, OembedParser parser) {
        return this.parser.put(format, parser);
    }

    public OembedResponse transformUrl(String url) throws OembedException {
        OembedResponse response = null;
        if (url == null || url.length() == 0) {
            this.logger.warn("Can't embed an empty url!");
        } else {
            if (this.cacheManager != null) {
                try {
                    this.logger.debug("Trying to use ehcache");
                    response = this.getFromCache(url);
                }
                catch (Exception e) {
                    this.logger.warn(String.format("There was a problem with ehcache: %s", e.getMessage()), (Throwable)e);
                }
            }
            if (response != null) {
                this.logger.debug("Using cached result...");
                if (response.isEmpty()) {
                    response = null;
                }
            } else {
                OembedProvider provider = this.findProvider(url);
                if (!(provider != null || this.isAutodiscovery() && (provider = this.autodiscoverOembedURIForUrl(url)) != null)) {
                    this.logger.info(String.format("No oembed provider for url %s and autodiscovery is disabled or found no result", url));
                } else {
                    try {
                        HttpResponse httpResponse;
                        URI api = provider.toApiUrl(url);
                        this.logger.debug(String.format("Calling url %s", api.toString()));
                        HttpGet request = new HttpGet(api);
                        if (this.userAgent != null) {
                            request.setHeader("User-Agent", String.format("%s%s", this.userAgent, this.consumer == null ? "" : "; " + this.consumer));
                        }
                        if ((httpResponse = this.httpClient.execute((HttpUriRequest)provider.getHttpRequestDecorator().decorate(request))).getStatusLine().getStatusCode() != 200) {
                            this.logger.warn(String.format("Server returned error %d for '%s': %s", httpResponse.getStatusLine().getStatusCode(), url, EntityUtils.toString((HttpEntity)httpResponse.getEntity())));
                            if (this.ignoreFailedUrlsForSeconds != null && this.cacheManager != null) {
                                OembedResponse emptyResponse = new OembedResponse();
                                emptyResponse.setEmpty(true);
                                emptyResponse.setCacheAge(this.ignoreFailedUrlsForSeconds);
                                this.addToCache(url, emptyResponse);
                            }
                        } else {
                            response = this.getParser(provider.getFormat().toLowerCase()).unmarshal(httpResponse.getEntity().getContent());
                            response.setSource(provider.getName());
                            response.setOriginalUrl(url);
                            if (this.cacheManager != null) {
                                try {
                                    this.addToCache(url, response);
                                }
                                catch (Exception e) {
                                    this.logger.warn(String.format("Could not cache response for %s: %s", url, e.getMessage(), e));
                                }
                            }
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        throw new OembedException(e);
                    }
                    catch (NullPointerException e) {
                        throw new OembedException(String.format("NPE, probably invalid format :%s", provider.getFormat()));
                    }
                    catch (Exception e) {
                        throw new OembedException(e);
                    }
                }
            }
        }
        return response;
    }

    public String transformDocumentString(String documentHtml) {
        Document rv = this.transformDocument(documentHtml);
        rv.outputSettings().prettyPrint(false).escapeMode(Entities.EscapeMode.xhtml);
        return rv.body().html();
    }

    public Document transformDocument(String documentHtml) {
        return this.transformDocument(Jsoup.parseBodyFragment((String)documentHtml, (String)this.baseUri));
    }

    public Document transformDocument(Document document) {
        boolean changedBaseUri = false;
        if (document.baseUri() == null && this.getBaseUri() != null) {
            document.setBaseUri(this.getBaseUri());
            changedBaseUri = true;
        }
        for (org.jsoup.nodes.Element a : document.getElementsByTag("a")) {
            String href = a.absUrl("href");
            try {
                String renderedRespose = null;
                OembedResponse oembedResponse = this.transformUrl(href);
                if (oembedResponse == null) continue;
                if (this.getHandler().containsKey(oembedResponse.getSource())) {
                    this.getHandler().get(oembedResponse.getSource()).handle(document, a, oembedResponse);
                    continue;
                }
                renderedRespose = oembedResponse.render();
                if (renderedRespose == null) continue;
                a.before(renderedRespose);
                a.remove();
            }
            catch (OembedException e) {
                this.logger.warn(String.format("Skipping '%s': %s", href, e.getMessage()));
            }
        }
        if (changedBaseUri) {
            document.setBaseUri(null);
        }
        return document;
    }

    private OembedProvider findProvider(String url) {
        OembedProvider rv = null;
        block0: for (OembedProvider provider : this.provider.values()) {
            for (String urlScheme : provider.getUrlSchemes()) {
                if (!url.matches(urlScheme)) continue;
                rv = provider;
                break block0;
            }
        }
        return rv;
    }

    private OembedProvider autodiscoverOembedURIForUrl(String url) {
        AutodiscoveredOembedProvider rv;
        block7: {
            rv = null;
            try {
                HttpGet request = new HttpGet(url);
                HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)request);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    this.logger.warn(String.format("Autodiscovery for %s failed, server returned error %d: %s", url, httpResponse.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)httpResponse.getEntity())));
                    break block7;
                }
                URI uri = request.getURI();
                Document document = Jsoup.parse((String)EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8"), (String)String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), uri.getPort()));
                for (org.jsoup.nodes.Element alternate : document.getElementsByAttributeValue("rel", "alternate")) {
                    if (alternate.attr("type").equalsIgnoreCase("application/json+oembed")) {
                        rv = new AutodiscoveredOembedProvider(url, new URI(alternate.absUrl("href")), "json");
                    } else if (alternate.attr("type").equalsIgnoreCase("text/xml+oembed")) {
                        rv = new AutodiscoveredOembedProvider(url, new URI(alternate.absUrl("href")), "xml");
                    }
                    if (rv == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.warn(String.format("Autodiscovery for %s failedd: %s", url, e.getMessage()), (Throwable)e);
            }
        }
        return rv;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public int getDefaultCacheAge() {
        return this.defaultCacheAge;
    }

    public void setDefaultCacheAge(int defaultCacheAge) {
        this.defaultCacheAge = defaultCacheAge;
    }

    public Map<String, OembedResponseHandler> getHandler() {
        return this.handler;
    }

    public void setHandler(Map<String, OembedResponseHandler> handler) {
        this.handler = handler;
    }

    public Map<String, OembedParser> getParser() {
        return this.parser;
    }

    public void setParser(Map<String, OembedParser> parser) {
        this.parser = parser;
    }

    public boolean isAutodiscovery() {
        return this.autodiscovery;
    }

    public void setAutodiscovery(boolean autodiscovery) {
        this.autodiscovery = autodiscovery;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    protected OembedResponse getFromCache(String key) {
        Cache cache = this.cacheManager.getCache(this.cacheName);
        if (cache == null) {
            this.cacheManager.addCache(this.cacheName);
            cache = this.cacheManager.getCache(this.cacheName);
        }
        OembedResponse rv = null;
        Element element = cache.get((Serializable)((Object)key));
        if (element != null) {
            rv = (OembedResponse)element.getObjectValue();
        }
        return rv;
    }

    protected void addToCache(String url, OembedResponse response) {
        Cache cache = this.cacheManager.getCache(this.cacheName);
        cache.put(new Element((Object)url, (Object)response, null, null, Integer.valueOf(response.getCacheAge() != null ? new Long(Math.min(Math.max(this.MIN_VALID_CACHE_AGE, response.getCacheAge()), this.MAX_VALID_CACHE_AGE)).intValue() : this.getDefaultCacheAge())));
    }

    public Long getIgnoreFailedUrlsForSeconds() {
        return this.ignoreFailedUrlsForSeconds;
    }

    public void setIgnoreFailedUrlsForSeconds(Long ignoreFailedUrlsForSeconds) {
        this.ignoreFailedUrlsForSeconds = ignoreFailedUrlsForSeconds;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public void setConsumer(String consumer) {
        this.consumer = consumer;
    }
}

