/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.Oembed;
import ac.simons.oembed.OembedProvider;
import ac.simons.oembed.OembedResponseHandler;
import java.util.HashMap;
import net.sf.ehcache.CacheManager;
import org.apache.http.client.HttpClient;

public class OembedBuilder {
    private final Oembed oembed;

    public OembedBuilder(HttpClient httpClient) {
        this.oembed = new Oembed(httpClient);
    }

    public OembedBuilder withCacheManager(CacheManager cacheManager) {
        this.oembed.setCacheManager(cacheManager);
        return this;
    }

    public OembedBuilder withDefaultCacheAge(int defaultCacheAge) {
        this.oembed.setDefaultCacheAge(defaultCacheAge);
        return this;
    }

    public OembedBuilder withAutodiscovery(boolean autodiscovery) {
        this.oembed.setAutodiscovery(autodiscovery);
        return this;
    }

    public OembedBuilder withBaseUri(String baseUri) {
        this.oembed.setBaseUri(baseUri);
        return this;
    }

    public OembedBuilder withCacheName(String cacheName) {
        this.oembed.setCacheName(cacheName);
        return this;
    }

    public OembedBuilder withIgnoreFailedUrlsForSeconds(Long ignoreFailedUrlsForSeconds) {
        this.oembed.setIgnoreFailedUrlsForSeconds(ignoreFailedUrlsForSeconds);
        return this;
    }

    public OembedBuilder withConsumer(String consumer) {
        this.oembed.setConsumer(consumer);
        return this;
    }

    public OembedBuilder withProviders(OembedProvider ... providers) {
        if (providers != null) {
            if (this.oembed.getProvider() == null) {
                this.oembed.setProvider(new HashMap<String, OembedProvider>());
            }
            for (OembedProvider provider : providers) {
                if (!this.oembed.getParser().containsKey(provider.getFormat().toLowerCase())) {
                    throw new RuntimeException(String.format("Invalid format %s", provider.getFormat()));
                }
                this.oembed.getProvider().put(provider.getName(), provider);
            }
        }
        return this;
    }

    public OembedBuilder withHandlers(OembedResponseHandler ... handlers) {
        if (handlers != null) {
            if (this.oembed.getHandler() == null) {
                this.oembed.setHandler(new HashMap<String, OembedResponseHandler>());
            }
            for (OembedResponseHandler handler : handlers) {
                this.oembed.getHandler().put(handler.getFor(), handler);
            }
        }
        return this;
    }

    public Oembed build() {
        return this.oembed;
    }
}

