/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="oembed")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OembedResponse
implements Serializable {
    private static final long serialVersionUID = -1965788850835022977L;
    @XmlTransient
    private String source;
    @XmlTransient
    private String originalUrl;
    @XmlTransient
    private boolean empty = false;
    @XmlElement(name="type")
    private String type;
    @XmlElement(name="version")
    private String version;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="author_name")
    private String authorName;
    @XmlElement(name="author_url")
    private String authorUrl;
    @XmlElement(name="provider_name")
    private String providerName;
    @XmlElement(name="provider_url")
    private String providerUrl;
    @XmlElement(name="cache_age")
    private Long cacheAge;
    @XmlElement(name="thumbnail_url")
    private String thumbnailUrl;
    @XmlElement(name="thumbnail_width")
    private Integer thumbnailWidth;
    @XmlElement(name="thumbnail_height")
    private Integer thumbnailHeight;
    @XmlElement(name="url")
    private String url;
    @XmlElement(name="html")
    private String html;
    @XmlElement(name="width")
    private Integer width;
    @XmlElement(name="height")
    private Integer height;

    public boolean from(String possibleSource) {
        return this.getSource() != null && this.source.equals(possibleSource);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String src) {
        this.source = src;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public void setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public Long getCacheAge() {
        return this.cacheAge;
    }

    public void setCacheAge(Long cacheAge) {
        this.cacheAge = cacheAge;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public Integer getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    public Integer getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String toString() {
        return "OembedResponse [type=" + this.type + ", version=" + this.version + ", title=" + this.title + ", authorName=" + this.authorName + ", authorUrl=" + this.authorUrl + ", providerName=" + this.providerName + ", providerUrl=" + this.providerUrl + ", cacheAge=" + this.cacheAge + ", thumbnailUrl=" + this.thumbnailUrl + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + ", url=" + this.url + ", html=" + this.html + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public String render() {
        String rv = null;
        if (this.getType().equalsIgnoreCase("photo")) {
            rv = this.renderPhoto();
        } else if (this.getType().equalsIgnoreCase("video")) {
            rv = this.renderVideo();
        } else if (this.getType().equalsIgnoreCase("link")) {
            rv = this.renderLink();
        } else if (this.getType().equalsIgnoreCase("rich")) {
            rv = this.renderRich();
        }
        return rv;
    }

    private String renderVideo() {
        return this.getHtml();
    }

    private String renderPhoto() {
        String _title = this.getTitle() == null ? "" : this.getTitle();
        return String.format("<img src=\"%s\" style=\"width:%dpx; height:%dpx;\" alt=\"%s\" title=\"%s\"/>", this.getUrl(), this.getWidth(), this.getHeight(), _title, _title);
    }

    private String renderLink() {
        String _title = this.getTitle() == null ? this.getOriginalUrl() : this.getTitle();
        String _url = this.getUrl() == null ? this.getOriginalUrl() : this.getUrl();
        return String.format("<a href=\"%s\">%s</a>", _url, _title);
    }

    private String renderRich() {
        return this.getHtml();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }
}

