/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.DefaultOembedProvider;
import ac.simons.oembed.HttpRequestDecorator;
import ac.simons.oembed.OembedProvider;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class OembedProviderBuilder {
    private final DefaultOembedProvider oembedProvider = new DefaultOembedProvider();

    public OembedProviderBuilder withName(String name) {
        this.oembedProvider.setName(name);
        return this;
    }

    public OembedProviderBuilder withFormat(String format) {
        this.oembedProvider.setFormat(format);
        return this;
    }

    public OembedProviderBuilder withEndpoint(String endpoint) {
        this.oembedProvider.setEndpoint(endpoint);
        return this;
    }

    public OembedProviderBuilder withUrlSchemes(String ... urlSchemes) {
        if (urlSchemes != null) {
            if (this.oembedProvider.getUrlSchemes() == null) {
                this.oembedProvider.setUrlSchemes(new ArrayList<String>());
            }
            for (String urlScheme : urlSchemes) {
                this.oembedProvider.getUrlSchemes().add(urlScheme);
            }
        }
        return this;
    }

    public OembedProviderBuilder withMaxHeight(Integer maxHeight) {
        this.oembedProvider.setMaxHeight(maxHeight);
        return this;
    }

    public OembedProviderBuilder withMaxWidth(Integer maxWidth) {
        this.oembedProvider.setMaxWidth(maxWidth);
        return this;
    }

    public OembedProviderBuilder withHttpRequestDecorator(HttpRequestDecorator httpRequestDecorator) {
        if (httpRequestDecorator == null) {
            throw new InvalidParameterException("HttpRequestDecorator may not be null!");
        }
        this.oembedProvider.setHttpRequestDecorator(httpRequestDecorator);
        return this;
    }

    public OembedProvider build() {
        return this.oembedProvider;
    }
}

