/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.oembed;

import ac.simons.oembed.DefaultHttpRequestDecorator;
import ac.simons.oembed.HttpRequestDecorator;
import ac.simons.oembed.OembedProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class DefaultOembedProvider
implements OembedProvider {
    private String name;
    private String endpoint;
    private String format;
    private Integer maxWidth;
    private Integer maxHeight;
    private List<String> urlSchemes;
    private HttpRequestDecorator httpRequestDecorator = new DefaultHttpRequestDecorator();

    @Override
    public URI toApiUrl(String url) throws URISyntaxException {
        String uri = null;
        ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
        if (this.getEndpoint().toLowerCase().contains("%{format}")) {
            uri = this.getEndpoint().replaceAll(Pattern.quote("%{format}"), this.getFormat());
        } else {
            uri = this.getEndpoint();
            query.add(new BasicNameValuePair("format", this.getFormat()));
        }
        query.add(new BasicNameValuePair("url", url));
        if (this.getMaxWidth() != null) {
            query.add(new BasicNameValuePair("maxwidth", this.getMaxWidth().toString()));
        }
        if (this.getMaxHeight() != null) {
            query.add(new BasicNameValuePair("maxheight", this.getMaxHeight().toString()));
        }
        return new URI(String.format("%s?%s", uri, URLEncodedUtils.format(query, (String)"UTF-8")));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String apiEndpoint) {
        this.endpoint = apiEndpoint;
    }

    @Override
    public List<String> getUrlSchemes() {
        return this.urlSchemes;
    }

    public void setUrlSchemes(List<String> urlSchemes) {
        this.urlSchemes = urlSchemes;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public HttpRequestDecorator getHttpRequestDecorator() {
        return this.httpRequestDecorator;
    }

    public void setHttpRequestDecorator(HttpRequestDecorator httpRequestDecorator) {
        this.httpRequestDecorator = httpRequestDecorator;
    }
}

