/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.autolinker;

import ac.simons.autolinker.AutoLinker;
import ac.simons.autolinker.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;

public final class TwitterUserAutoLinker
implements AutoLinker {
    @Override
    public List<Node> createLinks(TextNode textNode) {
        ArrayList<Node> rv = new ArrayList<Node>();
        int start = 0;
        String nodeText = textNode.getWholeText();
        String baseUri = textNode.baseUri();
        Matcher matcher = Regex.VALID_MENTION_OR_LIST.matcher(nodeText);
        while (matcher.find()) {
            String textBefore = String.format("%s%s", nodeText.substring(start, matcher.start()), matcher.group(1));
            if (!textBefore.isEmpty()) {
                rv.add((Node)new TextNode(textBefore));
            }
            Element newAnchor = new Element(Tag.valueOf((String)"a"), baseUri);
            newAnchor.attr("href", String.format("https://twitter.com/%s", matcher.group(3)));
            newAnchor.appendChild((Node)new TextNode(String.format("@%s", matcher.group(3))));
            rv.add((Node)newAnchor);
            start = matcher.end();
        }
        String textAfter = nodeText.substring(start);
        if (!textAfter.isEmpty()) {
            rv.add((Node)new TextNode(textAfter));
        }
        return rv;
    }
}

