/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.autolinker;

import java.util.Optional;

public final class Strings {
    private Strings() {
    }

    public static String truncate(String in, int length) {
        return Strings.truncate(in, length, "\u2026");
    }

    public static String truncate(String in, int length, String ellipsis) {
        String usedEllipsis = Optional.ofNullable(ellipsis).orElse("");
        int maxLength = length - usedEllipsis.codePointCount(0, usedEllipsis.length());
        if (maxLength < 0) {
            throw new IllegalArgumentException("Cannot truncate string to length < 0");
        }
        Object rv = in;
        if (in.codePointCount(0, in.length()) > length) {
            rv = new String(in.codePoints().limit(maxLength).toArray(), 0, maxLength) + usedEllipsis;
        }
        return rv;
    }
}

