/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.autolinker;

import ac.simons.autolinker.AutoLinker;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;

public final class EmailAddressAutoLinker
implements AutoLinker {
    private static final String VALID_EMAIL_ADDRESS_REGEX = "(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22))*\\x40(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d))*";
    public static final Pattern VALID_EMAIL_ADDRESS = Pattern.compile(String.format("\\A%s\\z", "(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22))*\\x40(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d))*"));
    public static final Pattern VALID_EMAIL_ADRESS_ML = Pattern.compile(String.format("(?m)(?<![^\\s])%s", "(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x22(?:[^\\x0d\\x22\\x5c\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x22))*\\x40(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d)(?:\\x2e(?:[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+|\\x5b(?:[^\\x0d\\x5b-\\x5d\\x80-\\xff]|\\x5c[\\x00-\\x7f])*\\x5d))*"));
    public static final Pattern AT_SIGNS = Pattern.compile("[@\uff20\\x40]");
    private final boolean hexEncodeEmailAddress;
    private final boolean obfuscateEmailAddress;

    public EmailAddressAutoLinker(boolean hexEncodeEmailAddress, boolean obfuscateEmailAddress) {
        this.hexEncodeEmailAddress = hexEncodeEmailAddress;
        this.obfuscateEmailAddress = obfuscateEmailAddress;
    }

    @Override
    public List<Node> createLinks(TextNode textNode) {
        ArrayList<Node> rv = new ArrayList<Node>();
        int start = 0;
        String nodeText = textNode.getWholeText();
        String baseUri = textNode.baseUri();
        Matcher matcher = VALID_EMAIL_ADRESS_ML.matcher(nodeText);
        while (matcher.find()) {
            String emailAddress = matcher.group();
            if (!new String(emailAddress.getBytes(), StandardCharsets.US_ASCII).equals(emailAddress)) continue;
            String textBefore = nodeText.substring(start, matcher.start());
            if (!textBefore.isEmpty()) {
                rv.add((Node)new TextNode(textBefore));
            }
            Element newAnchor = new Element(Tag.valueOf((String)"a"), baseUri);
            newAnchor.attr("href", String.format("%s%s", "mailto:", this.hexEncodeEmailAddress ? this.hexEncodeEmailAddress(emailAddress) : emailAddress));
            newAnchor.appendChild((Node)new TextNode(this.obfuscateEmailAddress ? this.obfuscateEmailAddress(emailAddress) : emailAddress));
            rv.add((Node)newAnchor);
            start = matcher.end();
        }
        String textAfter = nodeText.substring(start);
        if (!textAfter.isEmpty()) {
            rv.add((Node)new TextNode(textAfter));
        }
        return rv;
    }

    public String obfuscateEmailAddress(String emailAddress) {
        return AT_SIGNS.matcher(emailAddress.toLowerCase()).replaceAll(" [AT] ").replaceAll("\\.", " [DOT] ");
    }

    public String hexEncodeEmailAddress(String emailAddress) {
        String emailAddressLc = emailAddress.toLowerCase();
        StringBuilder rv = new StringBuilder();
        for (int i = 0; i < emailAddressLc.length(); ++i) {
            char c = emailAddressLc.charAt(i);
            rv.append(c == '@' ? Character.valueOf(c) : String.format("%%%x", c));
        }
        return rv.toString();
    }
}

