/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.autolinker;

import ac.simons.autolinker.AutoLinker;
import ac.simons.autolinker.Regex;
import ac.simons.autolinker.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;

public class UrlAutoLinker
implements AutoLinker {
    private final int maxLabelLength;

    public UrlAutoLinker(int maxLabelLength) {
        this.maxLabelLength = maxLabelLength;
    }

    @Override
    public List<Node> createLinks(TextNode textNode) {
        ArrayList<Node> rv = new ArrayList<Node>();
        int start = 0;
        String nodeText = textNode.getWholeText();
        String baseUri = textNode.baseUri();
        Matcher matcher = Regex.VALID_URL.matcher(nodeText);
        while (matcher.find()) {
            String textBefore = String.format("%s%s", nodeText.substring(start, matcher.start()), matcher.group(2));
            if (!textBefore.isEmpty()) {
                rv.add((Node)new TextNode(textBefore, baseUri));
            }
            Optional<String> protocol = Optional.ofNullable(matcher.group(4));
            Element newAnchor = new Element(Tag.valueOf((String)"a"), baseUri);
            String url = String.format("%s%s", protocol.isPresent() ? "" : "http://", matcher.group(3));
            newAnchor.attr("href", url);
            newAnchor.attr("title", url);
            newAnchor.appendChild((Node)new TextNode(Strings.truncate(matcher.group(3).replaceFirst(Pattern.quote(protocol.orElse("http://")), ""), this.maxLabelLength), baseUri));
            rv.add((Node)newAnchor);
            start = matcher.end();
        }
        String textAfter = nodeText.substring(start);
        if (!textAfter.isEmpty()) {
            rv.add((Node)new TextNode(textAfter, baseUri));
        }
        return rv;
    }
}

