/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.autolinker;

import ac.simons.autolinker.AutoLinker;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;

public class AutoLinkService {
    private final List<AutoLinker> autolinkers;

    public AutoLinkService(List<AutoLinker> autolinkers) {
        this.autolinkers = autolinkers;
    }

    Element applyAutoLinker(AutoLinker autoLinker, Element element) {
        List newChildNodes = element.childNodes().stream().collect(ArrayList::new, (l, childNode) -> {
            if (childNode instanceof Element) {
                Element childElement = (Element)childNode;
                if (childElement.tagName().equals("a")) {
                    l.add(childElement);
                } else {
                    l.add(this.applyAutoLinker(autoLinker, childElement));
                }
            } else if (childNode instanceof TextNode) {
                l.addAll(autoLinker.createLinks((TextNode)childNode));
            } else {
                l.add(childNode);
            }
        }, ArrayList::addAll);
        Element rv = new Element(element.tag(), element.baseUri(), element.attributes());
        newChildNodes.forEach(arg_0 -> ((Element)rv).appendChild(arg_0));
        return rv;
    }

    public String addLinks(String textWithLinkableStuff, Optional<String> baseUrl) {
        return this.addLinks(textWithLinkableStuff, baseUrl, String.class);
    }

    public <T> T addLinks(String textWithLinkableStuff, Optional<String> baseUrl, Class<? extends T> targetClass) {
        String rv;
        if (String.class.isAssignableFrom(targetClass)) {
            rv = textWithLinkableStuff;
        } else if (Document.class.isAssignableFrom(targetClass)) {
            rv = Document.createShell((String)baseUrl.orElse(""));
        } else {
            throw new RuntimeException(String.format("Invalid target class: %s", targetClass.getName()));
        }
        if (textWithLinkableStuff != null && !textWithLinkableStuff.trim().isEmpty()) {
            Document document = this.addLinks(Jsoup.parseBodyFragment((String)textWithLinkableStuff, (String)baseUrl.orElse("")));
            if (Document.class.isAssignableFrom(targetClass)) {
                rv = document;
            } else {
                document.outputSettings().prettyPrint(false).escapeMode(Entities.EscapeMode.xhtml).charset(StandardCharsets.UTF_8);
                rv = Parser.unescapeEntities((String)document.body().html().trim(), (boolean)true);
            }
        }
        return (T)rv;
    }

    public Document addLinks(Document document) {
        this.autolinkers.forEach(autoLinker -> {
            Element body = document.body();
            body.replaceWith((Node)this.applyAutoLinker((AutoLinker)autoLinker, body));
        });
        return document;
    }
}

