/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.akismet;

import ac.simons.akismet.AkismetException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class AkismetComment
implements Serializable {
    private static final long serialVersionUID = -5782832268604549364L;
    private String userIp;
    private String userAgent;
    private String referrer;
    private String permalink;
    private String commentType;
    private String commentAuthor;
    private String commentAuthorEmail;
    private String commentAuthorUrl;
    private String commentContent;

    private boolean areRequiredFieldsFilled() {
        return !StringUtils.isBlank((CharSequence)this.getUserIp()) && this.getUserAgent() != null;
    }

    public UrlEncodedFormEntity toEntity(String apiConsumer) throws Exception {
        ArrayList<BasicNameValuePair> p = new ArrayList<BasicNameValuePair>();
        if (!this.areRequiredFieldsFilled()) {
            throw new AkismetException("The fields blog, userIp and userAgent are required!");
        }
        p.add(new BasicNameValuePair("blog", apiConsumer));
        p.add(new BasicNameValuePair("user_ip", this.getUserIp()));
        p.add(new BasicNameValuePair("userAgent", this.getUserAgent()));
        if (!StringUtils.isBlank((CharSequence)this.getReferrer())) {
            p.add(new BasicNameValuePair("referrer", this.getReferrer()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getPermalink())) {
            p.add(new BasicNameValuePair("permalink", this.getPermalink()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getCommentType())) {
            p.add(new BasicNameValuePair("comment_type", this.getCommentType()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getCommentAuthor())) {
            p.add(new BasicNameValuePair("comment_author", this.getCommentAuthor()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getCommentAuthorEmail())) {
            p.add(new BasicNameValuePair("comment_author_email", this.getCommentAuthorEmail()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getCommentAuthorUrl())) {
            p.add(new BasicNameValuePair("comment_author_url", this.getCommentAuthorUrl()));
        }
        if (!StringUtils.isBlank((CharSequence)this.getCommentContent())) {
            p.add(new BasicNameValuePair("comment_content", this.getCommentContent()));
        }
        return new UrlEncodedFormEntity(p, "UTF-8");
    }

    @XmlElement(name="user_ip")
    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    @XmlElement(name="user_agent")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @XmlElement(name="referrer")
    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    @XmlElement(name="permalink")
    public String getPermalink() {
        return this.permalink;
    }

    public void setPermalink(String permalink) {
        this.permalink = permalink;
    }

    @XmlElement(name="comment_type")
    public String getCommentType() {
        return this.commentType;
    }

    public void setCommentType(String commentType) {
        this.commentType = commentType;
    }

    @XmlElement(name="comment_author")
    public String getCommentAuthor() {
        return this.commentAuthor;
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    @XmlElement(name="comment_author_email")
    public String getCommentAuthorEmail() {
        return this.commentAuthorEmail;
    }

    public void setCommentAuthorEmail(String commentAuthorEmail) {
        this.commentAuthorEmail = commentAuthorEmail;
    }

    @XmlElement(name="comment_author_url")
    public String getCommentAuthorUrl() {
        return this.commentAuthorUrl;
    }

    public void setCommentAuthorUrl(String commentAuthorUrl) {
        this.commentAuthorUrl = commentAuthorUrl;
    }

    @XmlElement(name="comment_content")
    public String getCommentContent() {
        return this.commentContent;
    }

    public void setCommentContent(String commentContent) {
        this.commentContent = commentContent;
    }

    public String toString() {
        return "AkismetComment [userIp=" + this.userIp + ", userAgent=" + this.userAgent + ", referrer=" + this.referrer + ", permalink=" + this.permalink + ", commentType=" + this.commentType + ", commentAuthor=" + this.commentAuthor + ", commentAuthorEmail=" + this.commentAuthorEmail + ", commentAuthorUrl=" + this.commentAuthorUrl + "]";
    }
}

