/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.akismet;

import ac.simons.akismet.AkismetComment;
import ac.simons.akismet.AkismetException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Akismet {
    private final String userAgent;
    private final String contentType = "application/x-www-form-urlencoded; charset=utf-8";
    private final Logger logger = LoggerFactory.getLogger(Akismet.class);
    private final HttpClient httpClient;
    private String apiEndpoint = "rest.akismet.com";
    private String apiVersion = "1.1";
    private String apiKey;
    private String apiConsumer;
    private boolean enabled = true;

    public Akismet(HttpClient httpClient) {
        this.httpClient = httpClient;
        Properties version = new Properties();
        try {
            version.load(Akismet.class.getResourceAsStream("/ac/simons/akismet/version.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userAgent = String.format("Java/%s java-akismet/%s", System.getProperty("java.version"), version.getProperty("ac.simons.akismet.version"));
        this.logger.info(String.format("Akismet (%s) ready...", this.userAgent));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apikey) {
        this.apiKey = apikey;
    }

    public String getApiConsumer() {
        return this.apiConsumer;
    }

    public void setApiConsumer(String apiConsumer) {
        this.apiConsumer = apiConsumer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private HttpPost newHttpPostRequest(String uri) {
        HttpPost request = new HttpPost(uri);
        request.setHeader("User-Agent", this.userAgent);
        request.setHeader("Content-Type", this.contentType);
        return request;
    }

    private HttpResponse callAkismet(String function, AkismetComment comment) throws Exception {
        HttpPost request = this.newHttpPostRequest(String.format("http://%s.%s/%s/%s", this.getApiKey(), this.getApiEndpoint(), this.getApiVersion(), function));
        request.setEntity((HttpEntity)comment.toEntity(this.getApiConsumer()));
        return this.getHttpClient().execute((HttpUriRequest)request);
    }

    public boolean verifyKey() throws AkismetException {
        boolean rv = false;
        try {
            HttpPost request = this.newHttpPostRequest(String.format("http://%s/%s/verify-key", this.getApiEndpoint(), this.getApiVersion()));
            ArrayList<BasicNameValuePair> p = new ArrayList<BasicNameValuePair>();
            p.add(new BasicNameValuePair("key", this.getApiKey()));
            p.add(new BasicNameValuePair("blog", this.getApiConsumer()));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(p, "UTF-8"));
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                rv = body.trim().equals("valid");
            } else {
                this.logger.warn(String.format("Something bad happened while verifying key, assuming key is invalid: %s", response.getStatusLine().getReasonPhrase()));
            }
        }
        catch (Exception e) {
            throw new AkismetException(e);
        }
        return rv;
    }

    public boolean commentCheck(AkismetComment comment) throws AkismetException {
        boolean rv = false;
        if (this.enabled) {
            try {
                HttpResponse response = this.callAkismet("comment-check", comment);
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) {
                    rv = body.trim().equals("true");
                } else {
                    this.logger.warn(String.format("Something bad happened while checking a comment, assuming comment is ham: %s", response.getStatusLine().getReasonPhrase()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Result for comment %s was: -> %s <-", comment.toString(), rv ? "spam" : "ham"));
                }
            }
            catch (Exception e) {
                throw new AkismetException(e);
            }
        }
        return rv;
    }

    public boolean submitSpam(AkismetComment comment) throws AkismetException {
        boolean rv = false;
        try {
            HttpResponse response = this.callAkismet("submit-spam", comment);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                this.logger.warn(String.format("Something bad happened while submitting Spam: %s", response.getStatusLine().getReasonPhrase()));
            } else {
                this.logger.debug(String.format("Spam successfully submitted, response was '%s'", body));
                rv = true;
            }
        }
        catch (Exception e) {
            throw new AkismetException(e);
        }
        return rv;
    }

    public boolean submitHam(AkismetComment comment) throws AkismetException {
        boolean rv = false;
        try {
            HttpResponse response = this.callAkismet("submit-ham", comment);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                this.logger.warn(String.format("Something bad happened while submitting ham: %s", response.getStatusLine().getReasonPhrase()));
            } else {
                this.logger.debug(String.format("Ham successfully submitted, response was '%s'", body));
                rv = true;
            }
        }
        catch (Exception e) {
            throw new AkismetException(e);
        }
        return rv;
    }
}

